/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.processor;

import io.quarkiverse.kafkastreamsprocessor.api.decorator.processor.AbstractProcessorDecorator;
import io.quarkiverse.kafkastreamsprocessor.impl.metrics.KafkaStreamsProcessorMetrics;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import org.apache.kafka.streams.processor.api.Record;

@Priority(value=400)
@Dependent
public class MetricsDecorator
extends AbstractProcessorDecorator {
    private final KafkaStreamsProcessorMetrics metrics;

    @Inject
    public MetricsDecorator(KafkaStreamsProcessorMetrics metrics) {
        this.metrics = metrics;
    }

    public void process(Record record) {
        try {
            this.getDelegate().process(record);
        }
        catch (Exception e) {
            this.metrics.processorErrorCounter().increment();
            throw e;
        }
    }

    private static interface Excludes {
        public <KIn, VIn> void process(Record<KIn, VIn> var1);
    }
}

