/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.processor;

import io.quarkiverse.kafkastreamsprocessor.api.decorator.processor.AbstractProcessorDecorator;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import org.apache.kafka.streams.processor.api.Record;

@Dependent
@Priority(value=200)
public class CdiRequestContextDecorator
extends AbstractProcessorDecorator {
    private final ArcContainer container;

    @Inject
    public CdiRequestContextDecorator() {
        this(Arc.container());
    }

    public CdiRequestContextDecorator(ArcContainer container) {
        this.container = container;
    }

    public void process(Record record) {
        if (this.container.requestContext().isActive()) {
            this.getDelegate().process(record);
        } else {
            this.container.requestContext().activate();
            try {
                this.getDelegate().process(record);
            }
            finally {
                this.container.requestContext().terminate();
            }
        }
    }
}

