/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.outputrecord;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.quarkiverse.kafkastreamsprocessor.api.decorator.outputrecord.OutputRecordInterceptor;
import io.quarkiverse.kafkastreamsprocessor.propagation.KafkaTextMapSetter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.processor.api.Record;

@ApplicationScoped
public class TracingOutputRecordInterceptor
implements OutputRecordInterceptor {
    private final OpenTelemetry openTelemetry;
    private final KafkaTextMapSetter kafkaTextMapSetter;

    @Inject
    public TracingOutputRecordInterceptor(OpenTelemetry openTelemetry, KafkaTextMapSetter kafkaTextMapSetter) {
        this.openTelemetry = openTelemetry;
        this.kafkaTextMapSetter = kafkaTextMapSetter;
    }

    public Record interceptOutputRecord(Record record) {
        this.openTelemetry.getPropagators().getTextMapPropagator().fields().forEach(arg_0 -> ((Headers)record.headers()).remove(arg_0));
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), (Object)record.headers(), (TextMapSetter)this.kafkaTextMapSetter);
        return record;
    }

    public int priority() {
        return 100;
    }
}

