/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.configuration;

import io.quarkiverse.kafkastreamsprocessor.api.configuration.Configuration;
import io.quarkiverse.kafkastreamsprocessor.api.configuration.store.GlobalStoreConfiguration;
import io.quarkiverse.kafkastreamsprocessor.api.configuration.store.StoreConfiguration;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public class TopologyConfigurationImpl
implements Configuration {
    private final Class<?> processorKeyType;
    private final Class<?> processorPayloadType;
    private Serializer<?> sinkKeySerializer;
    private Serde<?> sourceKeySerde;
    private Serializer<?> sinkValueSerializer;
    private Serde<?> sourceValueSerde;
    private List<StoreConfiguration> storeConfigurations = Collections.emptyList();
    private List<GlobalStoreConfiguration> globalStoreConfigurations = Collections.emptyList();

    public TopologyConfigurationImpl(Class<?> processorKeyType, Class<?> processorPayloadType) {
        this.processorKeyType = processorKeyType;
        this.processorPayloadType = processorPayloadType;
    }

    public void setStoreConfigurations(List<StoreConfiguration> storeConfigurations) {
        this.storeConfigurations = Collections.unmodifiableList(storeConfigurations);
    }

    public void setGlobalStoreConfigurations(List<GlobalStoreConfiguration> globalStoreConfigurations) {
        this.globalStoreConfigurations = Collections.unmodifiableList(globalStoreConfigurations);
    }

    @Generated
    public Class<?> getProcessorKeyType() {
        return this.processorKeyType;
    }

    @Generated
    public Class<?> getProcessorPayloadType() {
        return this.processorPayloadType;
    }

    @Generated
    public Serializer<?> getSinkKeySerializer() {
        return this.sinkKeySerializer;
    }

    @Generated
    public Serde<?> getSourceKeySerde() {
        return this.sourceKeySerde;
    }

    @Generated
    public Serializer<?> getSinkValueSerializer() {
        return this.sinkValueSerializer;
    }

    @Generated
    public Serde<?> getSourceValueSerde() {
        return this.sourceValueSerde;
    }

    @Generated
    public List<StoreConfiguration> getStoreConfigurations() {
        return this.storeConfigurations;
    }

    @Generated
    public List<GlobalStoreConfiguration> getGlobalStoreConfigurations() {
        return this.globalStoreConfigurations;
    }

    @Generated
    public void setSinkKeySerializer(Serializer<?> sinkKeySerializer) {
        this.sinkKeySerializer = sinkKeySerializer;
    }

    @Generated
    public void setSourceKeySerde(Serde<?> sourceKeySerde) {
        this.sourceKeySerde = sourceKeySerde;
    }

    @Generated
    public void setSinkValueSerializer(Serializer<?> sinkValueSerializer) {
        this.sinkValueSerializer = sinkValueSerializer;
    }

    @Generated
    public void setSourceValueSerde(Serde<?> sourceValueSerde) {
        this.sourceValueSerde = sourceValueSerde;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopologyConfigurationImpl)) {
            return false;
        }
        TopologyConfigurationImpl other = (TopologyConfigurationImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$processorKeyType = this.getProcessorKeyType();
        Class<?> other$processorKeyType = other.getProcessorKeyType();
        if (this$processorKeyType == null ? other$processorKeyType != null : !this$processorKeyType.equals(other$processorKeyType)) {
            return false;
        }
        Class<?> this$processorPayloadType = this.getProcessorPayloadType();
        Class<?> other$processorPayloadType = other.getProcessorPayloadType();
        if (this$processorPayloadType == null ? other$processorPayloadType != null : !this$processorPayloadType.equals(other$processorPayloadType)) {
            return false;
        }
        Serializer<?> this$sinkKeySerializer = this.getSinkKeySerializer();
        Serializer<?> other$sinkKeySerializer = other.getSinkKeySerializer();
        if (this$sinkKeySerializer == null ? other$sinkKeySerializer != null : !this$sinkKeySerializer.equals(other$sinkKeySerializer)) {
            return false;
        }
        Serde<?> this$sourceKeySerde = this.getSourceKeySerde();
        Serde<?> other$sourceKeySerde = other.getSourceKeySerde();
        if (this$sourceKeySerde == null ? other$sourceKeySerde != null : !this$sourceKeySerde.equals(other$sourceKeySerde)) {
            return false;
        }
        Serializer<?> this$sinkValueSerializer = this.getSinkValueSerializer();
        Serializer<?> other$sinkValueSerializer = other.getSinkValueSerializer();
        if (this$sinkValueSerializer == null ? other$sinkValueSerializer != null : !this$sinkValueSerializer.equals(other$sinkValueSerializer)) {
            return false;
        }
        Serde<?> this$sourceValueSerde = this.getSourceValueSerde();
        Serde<?> other$sourceValueSerde = other.getSourceValueSerde();
        if (this$sourceValueSerde == null ? other$sourceValueSerde != null : !this$sourceValueSerde.equals(other$sourceValueSerde)) {
            return false;
        }
        List<StoreConfiguration> this$storeConfigurations = this.getStoreConfigurations();
        List<StoreConfiguration> other$storeConfigurations = other.getStoreConfigurations();
        if (this$storeConfigurations == null ? other$storeConfigurations != null : !((Object)this$storeConfigurations).equals(other$storeConfigurations)) {
            return false;
        }
        List<GlobalStoreConfiguration> this$globalStoreConfigurations = this.getGlobalStoreConfigurations();
        List<GlobalStoreConfiguration> other$globalStoreConfigurations = other.getGlobalStoreConfigurations();
        return !(this$globalStoreConfigurations == null ? other$globalStoreConfigurations != null : !((Object)this$globalStoreConfigurations).equals(other$globalStoreConfigurations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopologyConfigurationImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $processorKeyType = this.getProcessorKeyType();
        result = result * 59 + ($processorKeyType == null ? 43 : $processorKeyType.hashCode());
        Class<?> $processorPayloadType = this.getProcessorPayloadType();
        result = result * 59 + ($processorPayloadType == null ? 43 : $processorPayloadType.hashCode());
        Serializer<?> $sinkKeySerializer = this.getSinkKeySerializer();
        result = result * 59 + ($sinkKeySerializer == null ? 43 : $sinkKeySerializer.hashCode());
        Serde<?> $sourceKeySerde = this.getSourceKeySerde();
        result = result * 59 + ($sourceKeySerde == null ? 43 : $sourceKeySerde.hashCode());
        Serializer<?> $sinkValueSerializer = this.getSinkValueSerializer();
        result = result * 59 + ($sinkValueSerializer == null ? 43 : $sinkValueSerializer.hashCode());
        Serde<?> $sourceValueSerde = this.getSourceValueSerde();
        result = result * 59 + ($sourceValueSerde == null ? 43 : $sourceValueSerde.hashCode());
        List<StoreConfiguration> $storeConfigurations = this.getStoreConfigurations();
        result = result * 59 + ($storeConfigurations == null ? 43 : ((Object)$storeConfigurations).hashCode());
        List<GlobalStoreConfiguration> $globalStoreConfigurations = this.getGlobalStoreConfigurations();
        result = result * 59 + ($globalStoreConfigurations == null ? 43 : ((Object)$globalStoreConfigurations).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TopologyConfigurationImpl(processorKeyType=" + String.valueOf(this.getProcessorKeyType()) + ", processorPayloadType=" + String.valueOf(this.getProcessorPayloadType()) + ", sinkKeySerializer=" + String.valueOf(this.getSinkKeySerializer()) + ", sourceKeySerde=" + String.valueOf(this.getSourceKeySerde()) + ", sinkValueSerializer=" + String.valueOf(this.getSinkValueSerializer()) + ", sourceValueSerde=" + String.valueOf(this.getSourceValueSerde()) + ", storeConfigurations=" + String.valueOf(this.getStoreConfigurations()) + ", globalStoreConfigurations=" + String.valueOf(this.getGlobalStoreConfigurations()) + ")";
    }
}

