/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl;

import io.quarkiverse.kafkastreamsprocessor.api.decorator.producer.ProducerOnSendInterceptor;
import jakarta.enterprise.inject.Instance;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;

public class KafkaClientSupplierDecorator
implements KafkaClientSupplier {
    public static final String DLQ_PRODUCER = "dlq.producer";
    private final KafkaClientSupplier delegate;
    private final Instance<ProducerOnSendInterceptor> interceptors;

    public KafkaClientSupplierDecorator(Instance<ProducerOnSendInterceptor> interceptors) {
        this((KafkaClientSupplier)new DefaultKafkaClientSupplier(), interceptors);
    }

    public Producer<byte[], byte[]> getProducer(Map<String, Object> config) {
        List<ProducerOnSendInterceptor> interceptorList = this.interceptors.stream().collect(Collectors.toList());
        Collections.sort(interceptorList, Comparator.comparingInt(ProducerOnSendInterceptor::priority));
        return new DecoratedProducer((Producer<byte[], byte[]>)this.delegate.getProducer(config), (Boolean)config.get(DLQ_PRODUCER), interceptorList);
    }

    @Generated
    KafkaClientSupplierDecorator(KafkaClientSupplier delegate, Instance<ProducerOnSendInterceptor> interceptors) {
        this.delegate = delegate;
        this.interceptors = interceptors;
    }

    @Generated
    public Admin getAdmin(Map<String, Object> config) {
        return this.delegate.getAdmin(config);
    }

    @Generated
    public Consumer<byte[], byte[]> getConsumer(Map<String, Object> arg0) {
        return this.delegate.getConsumer(arg0);
    }

    @Generated
    public Consumer<byte[], byte[]> getRestoreConsumer(Map<String, Object> arg0) {
        return this.delegate.getRestoreConsumer(arg0);
    }

    @Generated
    public Consumer<byte[], byte[]> getGlobalConsumer(Map<String, Object> arg0) {
        return this.delegate.getGlobalConsumer(arg0);
    }

    private static class DecoratedProducer
    implements Producer<byte[], byte[]> {
        private final Producer<byte[], byte[]> delegate;
        private final Boolean isDlqProducer;
        private final List<ProducerOnSendInterceptor> interceptorList;

        public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record) {
            return this.delegate.send(this.intercept(record));
        }

        public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record, Callback callback) {
            return this.delegate.send(this.intercept(record), callback);
        }

        private ProducerRecord<byte[], byte[]> intercept(ProducerRecord<byte[], byte[]> record) {
            for (ProducerOnSendInterceptor interceptor : this.interceptorList) {
                if (Boolean.TRUE.equals(this.isDlqProducer) && interceptor.skipForDLQ()) continue;
                record = interceptor.onSend(record);
            }
            return record;
        }

        @Generated
        public DecoratedProducer(Producer<byte[], byte[]> delegate, Boolean isDlqProducer, List<ProducerOnSendInterceptor> interceptorList) {
            this.delegate = delegate;
            this.isDlqProducer = isDlqProducer;
            this.interceptorList = interceptorList;
        }

        @Generated
        public void initTransactions() {
            this.delegate.initTransactions();
        }

        @Generated
        public void beginTransaction() throws ProducerFencedException {
            this.delegate.beginTransaction();
        }

        @Deprecated
        @Generated
        public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> arg0, String arg1) throws ProducerFencedException {
            this.delegate.sendOffsetsToTransaction(arg0, arg1);
        }

        @Generated
        public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> arg0, ConsumerGroupMetadata arg1) throws ProducerFencedException {
            this.delegate.sendOffsetsToTransaction(arg0, arg1);
        }

        @Generated
        public void commitTransaction() throws ProducerFencedException {
            this.delegate.commitTransaction();
        }

        @Generated
        public void abortTransaction() throws ProducerFencedException {
            this.delegate.abortTransaction();
        }

        @Generated
        public void flush() {
            this.delegate.flush();
        }

        @Generated
        public List<PartitionInfo> partitionsFor(String arg0) {
            return this.delegate.partitionsFor(arg0);
        }

        @Generated
        public Map<MetricName, ? extends Metric> metrics() {
            return this.delegate.metrics();
        }

        @Generated
        public Uuid clientInstanceId(Duration arg0) {
            return this.delegate.clientInstanceId(arg0);
        }

        @Generated
        public void close() {
            this.delegate.close();
        }

        @Generated
        public void close(Duration arg0) {
            this.delegate.close(arg0);
        }

        private static interface Excludes {
            public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> var1);

            public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> var1, Callback var2);
        }
    }

    private static interface Excludes {
        public Producer<byte[], byte[]> getProducer(Map<String, Object> var1);
    }
}

