/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.kafkastreamsprocessor.impl.AbstractIntrospectionSerializer;
import jakarta.inject.Inject;

public class IntrospectionSerializer
extends AbstractIntrospectionSerializer {
    private final ObjectMapper objectMapper;

    @Inject
    public IntrospectionSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    byte[] serializeNonProtobuf(Object data) {
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Message cannot be processed, one of the following payloads is expected: valid JSON Pojo or Protobuf", e);
        }
    }
}

