/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.quarkus.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import java.util.ArrayList;
import org.jboss.jandex.DotName;

class JdbiQuarkusProcessor {
    private static final String FEATURE = "quarkus-jdbi";
    private static final String PLUGIN = "org.jdbi.v3.core.spi.JdbiPlugin";

    JdbiQuarkusProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    IndexDependencyBuildItem indexExternalDependency(BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> markers) {
        markers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem("META-INF/services/org.jdbi.v3.core.spi.JdbiPlugin"));
        return new IndexDependencyBuildItem("org.jdbi", "jdbi3-core");
    }

    @BuildStep
    ReflectiveClassBuildItem reflectionConstructorOnly() {
        return new ReflectiveClassBuildItem(false, false, new String[]{"org.jdbi.v3.core.transaction.SerializableTransactionRunner$Configuration", "org.jdbi.v3.core.config.JdbiCaches", "org.jdbi.v3.core.statement.SqlStatements", "org.jdbi.v3.core.statement.StatementExceptions", "org.jdbi.v3.core.argument.Arguments", "org.jdbi.v3.core.mapper.RowMappers", "org.jdbi.v3.core.mapper.ColumnMappers", "org.jdbi.v3.core.mapper.Mappers", "org.jdbi.v3.core.mapper.MapMappers", "org.jdbi.v3.core.mapper.MapEntryMappers", "org.jdbi.v3.core.mapper.reflect.ReflectionMappers", "org.jdbi.v3.core.mapper.reflect.internal.PojoTypes", "org.jdbi.v3.core.collector.JdbiCollectors", "org.jdbi.v3.core.qualifier.Qualifiers", "org.jdbi.v3.core.result.ResultProducers", "org.jdbi.v3.core.array.SqlArrayTypes", "org.jdbi.v3.core.extension.Extensions", "org.jdbi.v3.core.internal.OnDemandExtensions", "org.jdbi.v3.core.internal.EnumStrategies", "org.jdbi.v3.core.enums.Enums", "org.jdbi.v3.core.Handles", "org.jdbi.v3.sqlobject.Handlers", "org.jdbi.v3.sqlobject.HandlerDecorators", "org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration", "org.jdbi.v3.sqlobject.SqlObjects", "com.github.benmanes.caffeine.cache.PSMS", "com.github.benmanes.caffeine.cache.SSMS", "org.jdbi.v3.postgres.PostgresTypes"});
    }

    @BuildStep
    ReflectiveClassBuildItem reflectionMethods() {
        return new ReflectiveClassBuildItem(true, false, new String[]{"com.github.benmanes.caffeine.cache.CacheLoader", "org.jdbi.v3.sqlobject.SqlObject"});
    }

    @BuildStep
    void registerForReflectionAllJdbiConfigImplementations(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectionClasses) {
        DotName jdbiConfig = DotName.createSimple((String)"org.jdbi.v3.core.config.JdbiConfig");
        index.getIndex().getAllKnownImplementors(jdbiConfig).forEach(info -> reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{info.name().toString()})));
    }

    @BuildStep
    void registerForReflectionAllJdbiPluginImplementations(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<ServiceProviderBuildItem> serviceProviders) {
        DotName plugin = DotName.createSimple((String)PLUGIN);
        ArrayList plugins = new ArrayList();
        index.getIndex().getAllKnownImplementors(plugin).forEach(info -> {
            String pluginName = info.name().toString();
            plugins.add(pluginName);
            reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{pluginName}));
        });
        serviceProviders.produce((BuildItem)new ServiceProviderBuildItem(PLUGIN, plugins));
    }
}

