/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.quarkus.deployment;

import com.google.common.collect.HashMultimap;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class JdbiAnnotationsQuarkusProcessor {
    private static final HashMultimap<DotName, String> annotationToHandlers = HashMultimap.create();
    private static Set<DotName> proxyTriggers = new HashSet<DotName>();
    private static final Set<DotName> registerAnnotations = new HashSet<DotName>();

    JdbiAnnotationsQuarkusProcessor() {
    }

    static void addConfig(String name, boolean register) {
        String triggerAnnotation = "org.jdbi.v3.sqlobject.config." + name;
        JdbiAnnotationsQuarkusProcessor.addHandler(triggerAnnotation, "org.jdbi.v3.sqlobject.config.internal." + name + "Impl");
        JdbiAnnotationsQuarkusProcessor.addClassReg(triggerAnnotation);
    }

    static void addLocator(String name) {
        String triggerAnnotation = "org.jdbi.v3.sqlobject.locator." + name;
        JdbiAnnotationsQuarkusProcessor.addHandler(triggerAnnotation, "org.jdbi.v3.sqlobject.locator.internal." + name + "Impl");
        JdbiAnnotationsQuarkusProcessor.addProxyTrigger(triggerAnnotation);
    }

    static void addStmtHandler(String name) {
        String triggerAnnotation = "org.jdbi.v3.sqlobject.statement." + name;
        JdbiAnnotationsQuarkusProcessor.addHandler(triggerAnnotation, "org.jdbi.v3.sqlobject.statement.internal." + name + "Handler");
        JdbiAnnotationsQuarkusProcessor.addProxyTrigger(triggerAnnotation);
    }

    static void addCustomizer(String name) {
        JdbiAnnotationsQuarkusProcessor.addHandler("org.jdbi.v3.sqlobject.customizer." + name, "org.jdbi.v3.sqlobject.customizer.internal." + name + "Factory");
    }

    static void addHandler(String triggerName, String handler) {
        annotationToHandlers.put((Object)DotName.createSimple((String)triggerName), (Object)handler);
    }

    static void addClassReg(String triggerAnnotation) {
        registerAnnotations.add(DotName.createSimple((String)triggerAnnotation));
    }

    static void addProxyTrigger(String triggerAnnotation) {
        proxyTriggers.add(DotName.createSimple((String)triggerAnnotation));
    }

    @BuildStep
    void findRegistrations(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectionClasses) {
        Consumer<AnnotationInstance> recordClasses = ai -> reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ai.value().asClass().name().toString()}));
        for (DotName registerAnnotation : registerAnnotations) {
            index.getIndex().getAnnotations(registerAnnotation).forEach(recordClasses);
        }
    }

    @BuildStep
    void findHandlers(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectionClasses) {
        for (DotName annotation : annotationToHandlers.keySet()) {
            if (index.getIndex().getAnnotations(annotation).isEmpty()) continue;
            Set handlers = annotationToHandlers.get((Object)annotation);
            for (String handler : handlers) {
                reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{handler}));
            }
        }
    }

    @BuildStep
    void registerProxyForSqlObject(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyClasses) {
        HashSet classes = new HashSet();
        HashSet<String> annotations = new HashSet<String>();
        Consumer<AnnotationInstance> recordClasses = ai -> {
            if (ai.target().kind() == AnnotationTarget.Kind.METHOD) {
                classes.add(ai.target().asMethod().declaringClass().name().toString());
            }
        };
        for (DotName proxyTrigger : proxyTriggers) {
            index.getIndex().getAnnotations(proxyTrigger).forEach(recordClasses);
            this.recordInterface(annotations, index, proxyTrigger);
        }
        index.getIndex().getAllKnownImplementors("org.jdbi.v3.sqlobject.SqlObject").forEach(cls -> classes.add(cls.name().toString()));
        String[] cls2 = new ArrayList(classes).toArray(new String[classes.size()]);
        String[] ann = new ArrayList<String>(annotations).toArray(new String[annotations.size()]);
        reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, true, false, cls2));
        reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, true, false, ann));
        proxyClasses.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(cls2));
    }

    private void recordInterface(Set<String> annotations, CombinedIndexBuildItem index, DotName iface) {
        annotations.add(iface.toString());
        ClassInfo cls = index.getIndex().getClassByName(iface);
        if (cls == null) {
            return;
        }
        cls.asClass().interfaceNames();
        List ifs = cls.asClass().interfaceNames();
        if (ifs == null) {
            return;
        }
        ifs.forEach(dt -> this.recordInterface(annotations, index, (DotName)dt));
    }

    static {
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterArgumentFactories", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterArgumentFactory", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterBeanMapper", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterBeanMappers", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterCollectorFactory", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterColumnMapper", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterColumnMapperFactories", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterColumnMapperFactory", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterColumnMappers", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterConstructorMapper", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterConstructorMappers", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterFieldMapper", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterFieldMappers", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterJoinRowMapper", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterObjectArgumentFactories", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterObjectArgumentFactory", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterRowMapper", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterRowMapperFactories", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterRowMapperFactory", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("RegisterRowMappers", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("UseEnumStrategy", false);
        JdbiAnnotationsQuarkusProcessor.addConfig("UseSqlParser", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("UseTemplateEngine", true);
        JdbiAnnotationsQuarkusProcessor.addConfig("KeyColumn", false);
        JdbiAnnotationsQuarkusProcessor.addConfig("ValueColumn", false);
        JdbiAnnotationsQuarkusProcessor.addLocator("UseAnnotationSqlLocator");
        JdbiAnnotationsQuarkusProcessor.addLocator("UseClasspathSqlLocator");
        JdbiAnnotationsQuarkusProcessor.addHandler("org.jdbi.v3.sqlobject.statement.MapTo", "org.jdbi.v3.sqlobject.statement.internal.MapToFactory");
        JdbiAnnotationsQuarkusProcessor.addStmtHandler("SqlBatch");
        JdbiAnnotationsQuarkusProcessor.addStmtHandler("SqlCall");
        JdbiAnnotationsQuarkusProcessor.addStmtHandler("SqlQuery");
        JdbiAnnotationsQuarkusProcessor.addStmtHandler("SqlScripts");
        JdbiAnnotationsQuarkusProcessor.addStmtHandler("SqlUpdate");
        JdbiAnnotationsQuarkusProcessor.addHandler("org.jdbi.v3.sqlobject.CreateSqlObject", "org.jdbi.v3.sqlobject.internal.CreateSqlObjectHandler");
        JdbiAnnotationsQuarkusProcessor.addProxyTrigger("org.jdbi.v3.sqlobject.CreateSqlObject");
        JdbiAnnotationsQuarkusProcessor.addClassReg("org.jdbi.v3.sqlobject.statement.UseRowMapper");
        JdbiAnnotationsQuarkusProcessor.addClassReg("org.jdbi.v3.sqlobject.statement.UseRowReducer");
        JdbiAnnotationsQuarkusProcessor.addProxyTrigger("org.jdbi.v3.sqlobject.statement.UseRowMapper");
        JdbiAnnotationsQuarkusProcessor.addProxyTrigger("org.jdbi.v3.sqlobject.statement.UseRowReducer");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("AllowUnusedBindings");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("Bind");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("BindBean");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("BindBeanList");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("BindFields");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("BindList");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("BindMap");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("BindMethods");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("BindMethodsList");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("BindPojo");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("Define");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("DefineList");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("DefineNamedBindings");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("FetchSize");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("MaxRows");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("OutParameter");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("OutParameterList");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("QueryTimeOut");
        JdbiAnnotationsQuarkusProcessor.addCustomizer("Timestamped");
        JdbiAnnotationsQuarkusProcessor.addHandler("org.jdbi.v3.sqlobject.customizer.Timestamped", "org.jdbi.v3.sqlobject.customizer.TimestampedConfig");
    }
}

