/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.parser.SimpleTextExtractingPdfContentStreamProcessor;
import java.io.IOException;

public class PdfTextExtractor {
    private final PdfReader reader;
    private final SimpleTextExtractingPdfContentStreamProcessor extractionProcessor;

    public PdfTextExtractor(PdfReader reader) {
        this.reader = reader;
        this.extractionProcessor = new SimpleTextExtractingPdfContentStreamProcessor();
    }

    private byte[] getContentBytesForPage(int pageNum) throws IOException {
        RandomAccessFileOrArray f = this.reader.getSafeFile();
        byte[] contentBytes = this.reader.getPageContent(pageNum, f);
        f.close();
        return contentBytes;
    }

    public String getTextFromPage(int page) throws IOException {
        int totalPages = this.reader.getNumberOfPages();
        if (totalPages < page) {
            throw new IOException("indicated page does not exists, requested page " + page + " document pages " + totalPages);
        }
        if (page <= 0) {
            throw new IOException("page number must be postive:" + page);
        }
        PdfDictionary pageDic = this.reader.getPageN(page);
        if (pageDic == null) {
            return "";
        }
        PdfDictionary resourcesDic = pageDic.getAsDict(PdfName.RESOURCES);
        this.extractionProcessor.processContent(this.getContentBytesForPage(page), resourcesDic);
        return this.extractionProcessor.getResultantText();
    }
}

