/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

final class VersionBean {
    public static final Version VERSION = new Version();

    VersionBean() {
    }

    public String getVendor() {
        return VERSION.getImplementationVendor();
    }

    public String getTitle() {
        return VERSION.getImplementationTitle();
    }

    public String getTimestamp() {
        return VERSION.getScmTimestamp();
    }

    public Version getVersion() {
        return VERSION;
    }

    public String toString() {
        return VERSION.toString();
    }

    public static class Version {
        private static final String UNKNOWN = "";
        private String implementationVendor = "";
        private String implementationVersion = "2.1.7";
        private String implementationTitle = "iText";
        private String scmTimestamp = "";
        private String fullVersionString = "";
        private boolean containsDataFromManifest = false;

        public Version() {
            this.initialize();
        }

        private String getAttributeValueOrDefault(Attributes attributes, String name) {
            String value = attributes.getValue(name);
            if (value == null) {
                value = UNKNOWN;
            }
            return value;
        }

        private void initialize() {
            Manifest manifest = null;
            try {
                manifest = this.readManifest();
                if (manifest != null) {
                    this.initializePropertiesFromManifest(manifest);
                    this.initializeDerivativeProperties();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void initializePropertiesFromManifest(Manifest manifest) {
            this.containsDataFromManifest = true;
            Attributes attributes = manifest.getMainAttributes();
            this.implementationVendor = this.getAttributeValueOrDefault(attributes, "Implementation-Vendor");
            this.implementationVersion = this.getAttributeValueOrDefault(attributes, "Implementation-Version");
            this.implementationTitle = this.getAttributeValueOrDefault(attributes, "Implementation-Title");
            this.scmTimestamp = this.getAttributeValueOrDefault(attributes, "SCM-Timestamp");
        }

        private void initializeDerivativeProperties() {
            this.fullVersionString = MessageFormat.format("{0}", this.implementationVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Manifest readManifest() {
            block36: {
                URL url;
                CodeSource codeSource;
                ProtectionDomain domain = VersionBean.class.getProtectionDomain();
                if (domain != null && (codeSource = domain.getCodeSource()) != null && (url = codeSource.getLocation()) != null) {
                    Manifest manifest;
                    InputStream manifestStream = null;
                    try {
                        URL manifestFileUrl;
                        Object manifestFile;
                        if ("vfs".equals(url.getProtocol())) {
                            manifestFile = String.format("%s/%s", url.toExternalForm(), "META-INF/MANIFEST.MF");
                            manifestFileUrl = new URL((String)manifestFile);
                        } else {
                            manifestFileUrl = new URL(url, "META-INF/MANIFEST.MF");
                        }
                        manifestStream = Version.urlToStream(manifestFileUrl);
                        manifestFile = new Manifest(manifestStream);
                        return manifestFile;
                    }
                    catch (MalformedURLException manifestFileUrl) {
                    }
                    catch (IOException manifestFileUrl) {
                    }
                    finally {
                        if (manifestStream != null) {
                            try {
                                manifestStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    ZipInputStream jis = null;
                    try {
                        URLConnection urlConnection = url.openConnection();
                        urlConnection.setUseCaches(false);
                        if (urlConnection instanceof JarURLConnection) {
                            JarURLConnection jarUrlConnection = (JarURLConnection)urlConnection;
                            Manifest manifest2 = jarUrlConnection.getManifest();
                            return manifest2;
                        }
                        jis = new JarInputStream(urlConnection.getInputStream());
                        manifest = ((JarInputStream)jis).getManifest();
                    }
                    catch (IOException iOException) {
                        break block36;
                    }
                    finally {
                        if (jis != null) {
                            try {
                                jis.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    return manifest;
                }
            }
            return null;
        }

        private static InputStream urlToStream(URL url) throws IOException {
            if (url != null) {
                URLConnection connection = url.openConnection();
                try {
                    connection.setUseCaches(false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return connection.getInputStream();
            }
            return null;
        }

        boolean containsDataFromManifest() {
            return this.containsDataFromManifest;
        }

        public String getVersion() {
            return this.fullVersionString;
        }

        public String getImplementationTitle() {
            return this.implementationTitle;
        }

        public String getImplementationVendor() {
            return this.implementationVendor;
        }

        public String getImplementationVersion() {
            return this.implementationVersion;
        }

        public String getScmTimestamp() {
            return this.scmTimestamp;
        }

        public String toString() {
            if (this.containsDataFromManifest()) {
                return this.getImplementationTitle() + " by " + this.getImplementationVendor() + ", version " + this.getVersion();
            }
            return this.getVersion();
        }
    }
}

