/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.itext.deployment;

import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.PdfName;
import io.quarkiverse.itext.runtime.ItextFeature;
import io.quarkiverse.itext.runtime.ItextRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.NativeImageEnableAllCharsetsBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class ItextProcessor {
    private static final String FEATURE = "itext";

    ItextProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(ItextFeature.class);
    }

    @BuildStep
    NativeImageEnableAllCharsetsBuildItem enableAllCharsetsBuildItem() {
        return new NativeImageEnableAllCharsetsBuildItem();
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("org.bouncycastle", "bcprov-jdk15on"));
        index.produce((BuildItem)new IndexDependencyBuildItem("org.bouncycastle", "bcpkix-jdk15on"));
        index.produce((BuildItem)new IndexDependencyBuildItem("org.bouncycastle", "bcmail-jdk15on"));
    }

    @BuildStep
    void registerFonts(BuildProducer<NativeImageResourcePatternsBuildItem> nativeImageResourcePatterns) {
        NativeImageResourcePatternsBuildItem.Builder builder = NativeImageResourcePatternsBuildItem.builder();
        builder.includeGlob("**/pdf/fonts/**");
        nativeImageResourcePatterns.produce((BuildItem)builder.build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerForReflection(ItextRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(this.collectSubclasses(combinedIndex, Image.class.getName()));
        classNames.add(PageSize.class.getName());
        classNames.add(PdfName.class.getName());
        classNames.add(Utilities.class.getName());
        classNames.add("com.lowagie.text.VersionBean");
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames.toArray(new String[0])).methods(true).fields(true).build());
    }

    public List<String> collectClassesInPackage(CombinedIndexBuildItem combinedIndex, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<DotName> packages = new ArrayList<DotName>(combinedIndex.getIndex().getSubpackages(packageName));
        packages.add(DotName.createSimple((String)packageName));
        for (DotName aPackage : packages) {
            List packageClasses = combinedIndex.getIndex().getClassesInPackage(aPackage).stream().map(ClassInfo::toString).collect(Collectors.toList());
            classes.addAll(packageClasses);
        }
        return classes;
    }

    public List<String> collectSubclasses(CombinedIndexBuildItem combinedIndex, String className) {
        List<String> classes = combinedIndex.getIndex().getAllKnownSubclasses(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toList());
        classes.add(className);
        return classes;
    }
}

