/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.hivemqclient.ssl;

import com.hivemq.client.internal.util.Checks;
import io.quarkiverse.hivemqclient.exceptions.SSLConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class KeyStoreUtil {
    private static final String DEFAULT_CERT_TYPE = "JKS";

    public static TrustManagerFactory trustManagerFromKeystore(File trustStoreFile, String trustStorePassword, String truststoreType) throws RuntimeException {
        TrustManagerFactory trustManagerFactory;
        Checks.notNull((Object)trustStoreFile, (String)"Trust store file");
        if (!DEFAULT_CERT_TYPE.equalsIgnoreCase(truststoreType)) {
            throw new SSLConfigException("Currently we only support JKS certificates, provided " + truststoreType);
        }
        FileInputStream fileInputStream = new FileInputStream(trustStoreFile);
        try {
            KeyStore keyStore = KeyStore.getInstance(truststoreType);
            keyStore.load(fileInputStream, trustStorePassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            trustManagerFactory = tmf;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException e) {
                throw new SSLConfigException("Not able to open or read trust store '" + trustStoreFile.getAbsolutePath() + "'", e);
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                throw new SSLConfigException("Not able to read certificate from trust store '" + trustStoreFile.getAbsolutePath() + "'", e);
            }
        }
        fileInputStream.close();
        return trustManagerFactory;
    }

    public static KeyManagerFactory keyManagerFromKeystore(File keyStoreFile, String keyStorePassword, String privateKeyPassword, String keystoreType) throws RuntimeException {
        KeyManagerFactory keyManagerFactory;
        Checks.notNull((Object)keyStoreFile, (String)"Key store file");
        FileInputStream fileInputStream = new FileInputStream(keyStoreFile);
        try {
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            keyStore.load(fileInputStream, keyStorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, privateKeyPassword.toCharArray());
            keyManagerFactory = kmf;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnrecoverableKeyException e) {
                throw new SSLConfigException("Not able to recover key from key store, please check your private key password and your key store password", e);
            }
            catch (IOException | KeyStoreException e) {
                throw new SSLConfigException("Not able to open or read key store '" + keyStoreFile.getAbsolutePath() + "'", e);
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                throw new SSLConfigException("Not able to read certificate from key store '" + keyStoreFile.getAbsolutePath() + "'", e);
            }
        }
        fileInputStream.close();
        return keyManagerFactory;
    }
}

