/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.hivemqclient.smallrye.reactive;

import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import io.quarkiverse.hivemqclient.smallrye.reactive.HiveMQMqttConnectorCommonConfiguration;
import io.quarkiverse.hivemqclient.ssl.IgnoreHostnameVerifier;
import io.quarkiverse.hivemqclient.ssl.KeyStoreUtil;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.mqtt.i18n.MqttLogging;
import io.vertx.mutiny.mqtt.messages.MqttPublishMessage;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class HiveMQClients {
    private static final Map<String, ClientHolder> clients = new ConcurrentHashMap<String, ClientHolder>();

    private HiveMQClients() {
    }

    static Uni<Mqtt3RxClient> getConnectedClient(HiveMQMqttConnectorCommonConfiguration options) {
        ClientHolder holder = HiveMQClients.getHolder(options);
        return holder.connect();
    }

    static ClientHolder getHolder(HiveMQMqttConnectorCommonConfiguration options) {
        String host = options.getHost();
        int def = options.getSsl() != false ? 8883 : 1883;
        int port = options.getPort().orElse(def);
        String server = options.getServerName().orElse("");
        String clientId = options.getClientId().orElse("");
        String id = host + ":" + port + "<" + server + ">-[" + clientId + "]";
        return clients.computeIfAbsent(id, key -> new ClientHolder(options));
    }

    static Mqtt3RxClient create(HiveMQMqttConnectorCommonConfiguration options) {
        Mqtt3ClientBuilder builder = (Mqtt3ClientBuilder)((Mqtt3ClientBuilder)Mqtt3Client.builder().serverHost(options.getHost())).serverPort(options.getPort().orElse(options.getSsl() != false ? 8883 : 1883).intValue());
        if (options.getAutoGeneratedClientId().booleanValue()) {
            builder.identifier(UUID.randomUUID().toString());
        }
        options.getClientId().ifPresent(clientid -> builder.identifier(clientid));
        options.getUsername().ifPresent(username -> HiveMQClients.setupBasicAuth(options, username, builder));
        if (options.getSsl().booleanValue()) {
            HiveMQClients.setupSslConfig(options, builder);
        }
        return ((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)builder.automaticReconnectWithDefaultConfig()).addConnectedListener(context -> MqttLogging.log.info((Object)String.format("connected to %s:%d", context.getClientConfig().getServerHost(), context.getClientConfig().getServerPort())))).buildRx();
    }

    private static void setupBasicAuth(HiveMQMqttConnectorCommonConfiguration options, String username, Mqtt3ClientBuilder builder) {
        ((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)builder.simpleAuth().username(username)).password(options.getPassword().orElseThrow(() -> new IllegalArgumentException("password null with authentication enabled (username not null)")).getBytes())).applySimpleAuth();
    }

    private static void setupSslConfig(HiveMQMqttConnectorCommonConfiguration options, Mqtt3ClientBuilder builder) {
        MqttClientSslConfigBuilder.Nested nested = builder.sslConfig();
        String truststoreLocation = options.getSslTruststoreLocation().orElseThrow(() -> new RuntimeException("Missing required 'ssl.truststore.location' property"));
        String truststorePassword = options.getSslTruststorePassword().orElseThrow(() -> new RuntimeException("Missing required 'ssl.truststore.password' property"));
        TrustManagerFactory trustManagerFactory = KeyStoreUtil.trustManagerFromKeystore(new File(truststoreLocation), truststorePassword, options.getSslTruststoreType());
        nested.trustManagerFactory(trustManagerFactory);
        HiveMQClients.setupMtlsConfig(options, (MqttClientSslConfigBuilder.Nested<? extends Mqtt3ClientBuilder>)nested);
        if (!options.getSslHostVerifier().booleanValue()) {
            nested.hostnameVerifier((HostnameVerifier)new IgnoreHostnameVerifier());
        }
        nested.applySslConfig();
    }

    private static void setupMtlsConfig(HiveMQMqttConnectorCommonConfiguration options, MqttClientSslConfigBuilder.Nested<? extends Mqtt3ClientBuilder> nested) {
        if (options.getSslKeystoreLocation().isPresent() || options.getSslKeystorePassword().isPresent()) {
            String keystoreLocation = options.getSslKeystoreLocation().orElseThrow(() -> new RuntimeException("Missing required 'ssl.keystore.location' property"));
            String keystorePassword = options.getSslKeystorePassword().orElseThrow(() -> new RuntimeException("Missing required 'ssl.keystore.password' property"));
            KeyManagerFactory keyManagerFactory = KeyStoreUtil.keyManagerFromKeystore(new File(keystoreLocation), keystorePassword, keystorePassword, options.getSslKeystoreType());
            nested.keyManagerFactory(keyManagerFactory);
        }
    }

    public static void clear() {
        clients.forEach((name, holder) -> holder.close());
        clients.clear();
    }

    public static void checkLiveness(HealthReport.HealthReportBuilder builder) {
        clients.forEach((name, holder) -> builder.add(name, holder.checkLiveness()));
    }

    public static void checkReadiness(HealthReport.HealthReportBuilder builder) {
        clients.forEach((name, holder) -> builder.add(name, holder.checkReadiness()));
    }

    public static class ClientHolder {
        private final Mqtt3RxClient client;
        private final Uni<Mqtt3ConnAck> connection;
        private final int livenessTimeout;
        private final int readinessTimeout;
        private final Boolean checkTopicEnabled;
        private long lastMqttUpdate = 0L;
        private final BroadcastProcessor<MqttPublishMessage> messages;

        public ClientHolder(HiveMQMqttConnectorCommonConfiguration options) {
            this.client = HiveMQClients.create(options);
            this.messages = BroadcastProcessor.create();
            this.livenessTimeout = options.getLivenessTimeout();
            this.readinessTimeout = options.getReadinessTimeout();
            this.checkTopicEnabled = options.getCheckTopicEnabled();
            if (this.checkTopicEnabled.booleanValue()) {
                ((Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete)this.client.toAsync().subscribeWith().topicFilter(options.getCheckTopicName())).callback(m -> {
                    MqttLogging.log.debug((Object)new String(m.getPayloadAsBytes()));
                    this.lastMqttUpdate = System.currentTimeMillis();
                }).send();
            }
            this.connection = Uni.createFrom().future(this.client.connect().toFuture());
            this.connection.subscribe().with(c -> MqttLogging.log.info((Object)c.getReturnCode()));
        }

        public Uni<Mqtt3RxClient> connect() {
            return this.connection.map(ignored -> this.client);
        }

        public boolean checkLiveness() {
            if (!this.checkTopicEnabled.booleanValue()) {
                return true;
            }
            return System.currentTimeMillis() - this.lastMqttUpdate < (long)this.livenessTimeout;
        }

        public boolean checkReadiness() {
            if (!this.checkTopicEnabled.booleanValue()) {
                return true;
            }
            return System.currentTimeMillis() - this.lastMqttUpdate < (long)this.readinessTimeout;
        }

        public void close() {
            Mqtt3BlockingClient mqtt3BlockingClient = this.client.toBlocking();
            if (mqtt3BlockingClient.getState().isConnected()) {
                mqtt3BlockingClient.disconnect();
            }
        }
    }
}

