package io.quarkiverse.hivemqclient.smallrye.reactive;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;

/**
 * Extract the outgoing configuration for the {@code smallrye-mqtt-hivemq} connector.
*/
public class HiveMQMqttConnectorOutgoingConfiguration extends HiveMQMqttConnectorCommonConfiguration {

  /**
   * Creates a new HiveMQMqttConnectorOutgoingConfiguration.
   */
  public HiveMQMqttConnectorOutgoingConfiguration(Config config) {
    super(config);
    validate();
  }

  /**
  * Gets the merge value from the configuration.
  * Attribute Name: merge
  * Description: Whether the connector should allow multiple upstreams
  * Default Value: false
  * @return the merge
  */
  public Boolean getMerge() {
    return config.getOptionalValue("merge", Boolean.class)
     .orElse(Boolean.valueOf("false"));
  }

  public void validate() {
    super.validate();
  }
}
