/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.hivemqclient.smallrye.reactive;

import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import io.quarkiverse.hivemqclient.smallrye.reactive.HiveMQMqttConnectorCommonConfiguration;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.UniConverter;
import io.smallrye.mutiny.converters.uni.UniRxConverters;
import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.mqtt.i18n.MqttLogging;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.TrustManagerFactory;

public class HiveMQClients {
    private static final Map<String, ClientHolder> clients = new ConcurrentHashMap<String, ClientHolder>();

    private HiveMQClients() {
    }

    static Uni<Mqtt3RxClient> getConnectedClient(HiveMQMqttConnectorCommonConfiguration options) {
        ClientHolder holder = HiveMQClients.getHolder(options);
        return holder.connect();
    }

    static ClientHolder getHolder(HiveMQMqttConnectorCommonConfiguration options) {
        String host = options.getHost();
        int def = options.getSsl() != false ? 8883 : 1883;
        int port = options.getPort().orElse(def);
        String server = options.getServerName().orElse("");
        String clientId = options.getClientId().orElse("");
        String id = host + ":" + port + "<" + server + ">-[" + clientId + "]";
        return clients.computeIfAbsent(id, key -> new ClientHolder(options));
    }

    static Mqtt3RxClient create(HiveMQMqttConnectorCommonConfiguration options) {
        Mqtt3ClientBuilder builder = (Mqtt3ClientBuilder)((Mqtt3ClientBuilder)Mqtt3Client.builder().serverHost(options.getHost())).serverPort(options.getPort().orElse(options.getSsl() != false ? 8883 : 1883).intValue());
        if (options.getAutoGeneratedClientId().booleanValue()) {
            builder.identifier(UUID.randomUUID().toString());
        }
        options.getClientId().ifPresent(clientid -> builder.identifier(clientid));
        options.getUsername().ifPresent(username -> ((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)builder.simpleAuth().username(username)).password(options.getPassword().orElseThrow(() -> new IllegalArgumentException("password null with authentication enabled (username not null)")).getBytes())).applySimpleAuth());
        if (options.getSsl().booleanValue()) {
            MqttClientSslConfigBuilder.Nested nested = builder.sslConfig();
            options.getCaCartFile().ifPresent(file -> nested.trustManagerFactory(HiveMQClients.createSelfSignedTrustManagerFactory(file)));
            nested.applySslConfig();
        }
        return ((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)builder.automaticReconnectWithDefaultConfig()).addConnectedListener(context -> MqttLogging.log.info((Object)String.format("connected to %s:%d", context.getClientConfig().getServerHost(), context.getClientConfig().getServerPort())))).buildRx();
    }

    public static void clear() {
        clients.forEach((name, holder) -> holder.close());
        clients.clear();
    }

    public static void checkLiveness(HealthReport.HealthReportBuilder builder) {
        clients.forEach((name, holder) -> builder.add(name, holder.checkLiveness()));
    }

    public static void checkReadiness(HealthReport.HealthReportBuilder builder) {
        clients.forEach((name, holder) -> builder.add(name, holder.checkReadiness()));
    }

    public static TrustManagerFactory createSelfSignedTrustManagerFactory(String selfSignedTrustManager) {
        try {
            Certificate ca;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(selfSignedTrustManager);
            try (BufferedInputStream caInput = new BufferedInputStream(is);){
                ca = cf.generateCertificate(caInput);
            }
            String keyStoreType = KeyStore.getDefaultType();
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null, null);
            keyStore.setCertificateEntry("ca", ca);
            String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
            tmf.init(keyStore);
            return tmf;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ClientHolder {
        private final Mqtt3RxClient client;
        private final Uni<Mqtt3ConnAck> connection;
        private final int livenessTimeout;
        private final int readinessTimeout;
        private final Boolean checkTopicEnabled;
        private long lastMqttUpdate = 0L;

        public ClientHolder(HiveMQMqttConnectorCommonConfiguration options) {
            this.client = HiveMQClients.create(options);
            this.livenessTimeout = options.getLivenessTimeout();
            this.readinessTimeout = options.getReadinessTimeout();
            this.checkTopicEnabled = options.getCheckTopicEnabled();
            if (this.checkTopicEnabled.booleanValue()) {
                ((Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete)this.client.toAsync().subscribeWith().topicFilter(options.getCheckTopicName())).callback(m -> {
                    MqttLogging.log.debug((Object)new String(m.getPayloadAsBytes()));
                    this.lastMqttUpdate = System.currentTimeMillis();
                }).send();
            }
            this.connection = Uni.createFrom().converter((UniConverter)UniRxConverters.fromSingle(), (Object)this.client.connect()).memoize().indefinitely();
        }

        public Uni<Mqtt3RxClient> connect() {
            return this.connection.map(ignored -> this.client);
        }

        public boolean checkLiveness() {
            if (!this.checkTopicEnabled.booleanValue()) {
                return true;
            }
            return System.currentTimeMillis() - this.lastMqttUpdate < (long)this.livenessTimeout;
        }

        public boolean checkReadiness() {
            if (!this.checkTopicEnabled.booleanValue()) {
                return true;
            }
            return System.currentTimeMillis() - this.lastMqttUpdate < (long)this.readinessTimeout;
        }

        public void close() {
            Mqtt3BlockingClient mqtt3BlockingClient = this.client.toBlocking();
            if (mqtt3BlockingClient.getState().isConnected()) {
                mqtt3BlockingClient.disconnect();
            }
        }
    }
}

