/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.groovy.jaxb.deployment;

import io.quarkiverse.groovy.deployment.GroovyUtil;
import io.quarkiverse.groovy.jaxb.deployment.GroovyJAXBEnhancer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.jaxb.deployment.JaxbClassesToBeBoundBuildItem;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class GroovyJAXBProcessor {
    private static final Logger log = Logger.getLogger(GroovyJAXBProcessor.class);

    GroovyJAXBProcessor() {
    }

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("groovy-jaxb");
    }

    @BuildStep
    void transform(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, List<JaxbClassesToBeBoundBuildItem> jaxbClasses) {
        IndexView view = index.getIndex();
        HashSet<String> classesToTransform = new HashSet<String>();
        HashSet<String> classesProcessed = new HashSet<String>();
        for (JaxbClassesToBeBoundBuildItem item : jaxbClasses) {
            for (String className : item.getClasses()) {
                this.addClassesToTransform(view, className, classesToTransform, classesProcessed);
            }
        }
        if (classesToTransform.isEmpty()) {
            return;
        }
        GroovyJAXBEnhancer enhancer = new GroovyJAXBEnhancer();
        classesToTransform.forEach(name -> transformers.produce((BuildItem)new BytecodeTransformerBuildItem(name, (BiFunction)enhancer)));
    }

    private void addClassesToTransform(IndexView view, String className, Set<String> classesToTransform, Set<String> classesProcessed) {
        if (classesProcessed.add(className) && !GroovyUtil.isGroovyClass((String)className) && !GroovyJAXBProcessor.isJDKClass(className)) {
            ClassInfo classInfo = view.getClassByName(className);
            if (classInfo == null) {
                log.warnf("The class %s could not be found in the index", (Object)className);
                return;
            }
            if (GroovyUtil.isGroovyObject((ClassInfo)classInfo)) {
                classesToTransform.add(className);
            }
            for (FieldInfo fieldInfo : classInfo.fields()) {
                if (Modifier.isStatic(fieldInfo.flags())) continue;
                this.addClassesToTransform(view, fieldInfo.type(), classesToTransform, classesProcessed);
            }
        }
    }

    private void addClassesToTransform(IndexView view, Type type, Set<String> classesToTransform, Set<String> classesProcessed) {
        if (type.kind() == Type.Kind.CLASS) {
            this.addClassesToTransform(view, type.name().toString(), classesToTransform, classesProcessed);
        } else if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            for (Type pType : type.asParameterizedType().arguments()) {
                this.addClassesToTransform(view, pType, classesToTransform, classesProcessed);
            }
        } else if (type.kind() == Type.Kind.ARRAY) {
            this.addClassesToTransform(view, type.asArrayType().component(), classesToTransform, classesProcessed);
        }
    }

    private static boolean isJDKClass(String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("jdk.");
    }
}

