/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.groovy.hibernate.reactive.panache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkiverse.groovy.hibernate.reactive.panache.runtime.JpaOperations;
import io.quarkus.panache.common.impl.GenerateBridge;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import jakarta.json.bind.annotation.JsonbTransient;
import java.util.stream.Stream;
import org.hibernate.reactive.mutiny.Mutiny;

public abstract class PanacheEntityBase {
    public static Uni<Mutiny.Session> getSession() {
        return JpaOperations.INSTANCE.getSession();
    }

    @CheckReturnValue
    public <T extends PanacheEntityBase> Uni<T> persist() {
        return JpaOperations.INSTANCE.persist(this).map(v -> this);
    }

    @CheckReturnValue
    public <T extends PanacheEntityBase> Uni<T> persistAndFlush() {
        return JpaOperations.INSTANCE.persist(this).flatMap(v -> JpaOperations.INSTANCE.flush()).map(v -> this);
    }

    @CheckReturnValue
    public Uni<Void> delete() {
        return JpaOperations.INSTANCE.delete(this);
    }

    @JsonbTransient
    @JsonIgnore
    public boolean isPersistent() {
        return JpaOperations.INSTANCE.isPersistent(this);
    }

    @CheckReturnValue
    public Uni<Void> flush() {
        return JpaOperations.INSTANCE.flush();
    }

    @CheckReturnValue
    @GenerateBridge(callSuperMethod=true)
    public static Uni<Void> persist(Iterable<?> entities) {
        return JpaOperations.INSTANCE.persist(entities);
    }

    @CheckReturnValue
    @GenerateBridge(callSuperMethod=true)
    public static Uni<Void> persist(Stream<?> entities) {
        return JpaOperations.INSTANCE.persist(entities);
    }

    @CheckReturnValue
    @GenerateBridge(callSuperMethod=true)
    public static Uni<Void> persist(Object firstEntity, Object ... entities) {
        return JpaOperations.INSTANCE.persist(firstEntity, entities);
    }
}

