/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.groovy.deployment;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class GroovyUtil {
    public static final DotName DOTNAME_GROOVY_OBJECT = DotName.createSimple((String)GroovyObject.class.getName());
    public static final String METHOD_GET_META_CLASS_NAME = "getMetaClass";
    public static final String METHOD_GET_META_CLASS_DESCRIPTOR = String.format("()L%s;", MetaClass.class.getName().replace('.', '/'));
    private static final List<String> GROOVY_PACKAGE_NAMES = List.of("org.codehaus.groovy.", "org.apache.groovy.", "groovy");

    private GroovyUtil() {
    }

    public static boolean isGroovyObject(ClassInfo classInfo) {
        for (Type interfaceType : classInfo.interfaceTypes()) {
            if (!DOTNAME_GROOVY_OBJECT.equals((Object)interfaceType.name())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGetMetaClassMethod(String name, String descriptor) {
        return METHOD_GET_META_CLASS_NAME.equals(name) && METHOD_GET_META_CLASS_DESCRIPTOR.equals(descriptor);
    }

    public static boolean isGroovyClass(String name) {
        for (String prefix : GROOVY_PACKAGE_NAMES) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

