/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapi.deployment;

import io.quarkiverse.githubapi.deployment.GitHubApiClassWithBridgeMethodsBuildItem;
import io.quarkiverse.githubapi.deployment.GitHubApiDotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import org.jboss.jandex.DotName;
import org.kohsuke.github.connector.GitHubConnector;
import org.kohsuke.github.extras.HttpClientGitHubConnector;

class GithubApiProcessor {
    private static final String FEATURE = "github-api";

    GithubApiProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem requireSsl() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    IndexDependencyBuildItem indexGitHubApiJar() {
        return new IndexDependencyBuildItem("org.kohsuke", FEATURE);
    }

    @BuildStep
    void classesWithBridgeMethods(BuildProducer<GitHubApiClassWithBridgeMethodsBuildItem> classesWithBridgeMethods) {
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GHAppInstallationToken", "getExpiresAt"));
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GHCheckRun", "getStatus", "getConclusion"));
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GHCommit", "getAuthor", "getCommitter"));
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GHCompare", "getAuthor", "getCommitter"));
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GHIssue", "comment", "addLabels", "removeLabel", "removeLabels"));
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GHObject", "getCreatedAt", "getUrl", "getHtmlUrl", "getId"));
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GHPullRequestCommitDetail$Commit", "getAuthor", "getCommitter"));
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GHRepository", "getCollaborators"));
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GHUser", "getFollows", "getFollowers", "getOrganizations"));
        classesWithBridgeMethods.produce((BuildItem)new GitHubApiClassWithBridgeMethodsBuildItem("org.kohsuke.github.GitHub", "getMyself"));
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        for (DotName rootModelObject : GitHubApiDotNames.GH_ROOT_OBJECTS) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{rootModelObject.toString()}));
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, (String[])combinedIndex.getIndex().getAllKnownSubclasses(rootModelObject).stream().map(ci -> ci.name().toString()).toArray(String[]::new)));
        }
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, (String[])GitHubApiDotNames.GH_SIMPLE_OBJECTS.stream().map(DotName::toString).toArray(String[]::new)));
    }

    @BuildStep
    void runtimeInitialized(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(HttpClientGitHubConnector.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(GitHubConnector.class.getName()));
    }
}

