/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapi.deployment;

import io.quarkiverse.githubapi.deployment.GitHubApiDotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.DotName;

class GithubApiProcessor {
    private static final String FEATURE = "github-api";

    GithubApiProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem requireSsl() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    IndexDependencyBuildItem indexGitHubApiJar() {
        return new IndexDependencyBuildItem("org.kohsuke", FEATURE);
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        for (DotName rootModelObject : GitHubApiDotNames.GH_ROOT_OBJECTS) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{rootModelObject.toString()}));
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, (String[])combinedIndex.getIndex().getAllKnownSubclasses(rootModelObject).stream().map(ci -> ci.name().toString()).toArray(String[]::new)));
        }
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, (String[])GitHubApiDotNames.GH_SIMPLE_OBJECTS.stream().map(DotName::toString).toArray(String[]::new)));
    }
}

