/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.dapr.deployment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dapr.Topic;
import io.dapr.actors.runtime.ActorRuntimeConfig;
import io.quarkiverse.dapr.core.DaprTopicSubscription;
import io.quarkiverse.dapr.deployment.DaprTopicBuildItem;
import io.quarkiverse.dapr.endpoint.actor.ActorDeactivateHandler;
import io.quarkiverse.dapr.endpoint.actor.ActorInvokeMethodHandler;
import io.quarkiverse.dapr.endpoint.actor.ActorInvokeReminderHandler;
import io.quarkiverse.dapr.endpoint.actor.ActorInvokeTimerHandler;
import io.quarkiverse.dapr.endpoint.dapr.AbstractDaprHandler;
import io.quarkiverse.dapr.endpoint.dapr.DaprConfigHandler;
import io.quarkiverse.dapr.endpoint.dapr.DaprSubscribeHandler;
import io.quarkiverse.dapr.jackson.DaprJacksonModuleCustomizer;
import io.quarkiverse.dapr.runtime.DaprProducer;
import io.quarkiverse.dapr.runtime.DaprRuntimeRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.vertx.core.Handler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DaprProcessor {
    private static final Logger log = LoggerFactory.getLogger(DaprProcessor.class);
    private static final String FEATURE = "dapr";
    private static final DotName DAPR_TOPIC = DotName.createSimple((String)Topic.class.getName());
    private static final DotName RESTEASY_PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    private static final DotName RESTEASY_POST = DotName.createSimple((String)"javax.ws.rs.POST");
    private static final TypeReference<HashMap<String, String>> MAP_TYPE = new TypeReference<HashMap<String, String>>(){};
    private static final ObjectMapper objectMapper = new ObjectMapper();

    DaprProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void addDaprEndpoint(BuildProducer<RouteBuildItem> routeBuildItemBuildProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        routeBuildItemBuildProducer.produce((BuildItem)this.getDaprRouteBuildItem(nonApplicationRootPathBuildItem, (AbstractDaprHandler)new DaprConfigHandler()));
        routeBuildItemBuildProducer.produce((BuildItem)this.getDaprRouteBuildItem(nonApplicationRootPathBuildItem, (AbstractDaprHandler)new DaprSubscribeHandler()));
    }

    @BuildStep
    void addActorEndpoint(BuildProducer<RouteBuildItem> routeBuildItemBuildProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        routeBuildItemBuildProducer.produce((BuildItem)this.getDaprRouteBuildItem(nonApplicationRootPathBuildItem, (AbstractDaprHandler)new ActorDeactivateHandler()));
        routeBuildItemBuildProducer.produce((BuildItem)this.getDaprRouteBuildItem(nonApplicationRootPathBuildItem, (AbstractDaprHandler)new ActorInvokeMethodHandler()));
        routeBuildItemBuildProducer.produce((BuildItem)this.getDaprRouteBuildItem(nonApplicationRootPathBuildItem, (AbstractDaprHandler)new ActorInvokeTimerHandler()));
        routeBuildItemBuildProducer.produce((BuildItem)this.getDaprRouteBuildItem(nonApplicationRootPathBuildItem, (AbstractDaprHandler)new ActorInvokeReminderHandler()));
    }

    @BuildStep
    void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(DaprProducer.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(DaprJacksonModuleCustomizer.class));
    }

    @BuildStep
    void daprTopicBuildItems(BuildProducer<DaprTopicBuildItem> topicProducer, CombinedIndexBuildItem indexBuildItem) {
        for (AnnotationInstance i : indexBuildItem.getIndex().getAnnotations(DAPR_TOPIC)) {
            if (i.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo methodInfo = i.target().asMethod();
            ClassInfo classInfo = methodInfo.declaringClass();
            Optional<AnnotationInstance> methodPostOp = methodInfo.annotations().stream().filter(annotation -> annotation.name().equals((Object)RESTEASY_POST)).findFirst();
            methodPostOp.ifPresent(mp -> {
                Optional<AnnotationInstance> classPathOp = classInfo.annotations().entrySet().stream().filter(entry -> ((DotName)entry.getKey()).equals((Object)RESTEASY_PATH)).map(Map.Entry::getValue).flatMap(list -> list.stream()).filter(a -> a.target().kind() == AnnotationTarget.Kind.CLASS).findFirst();
                String methodPath = null;
                AnnotationInstance topic = null;
                for (AnnotationInstance annotation : methodInfo.annotations()) {
                    DotName name = annotation.name();
                    if (name.equals((Object)RESTEASY_PATH)) {
                        methodPath = annotation.value().asString();
                    }
                    if (!name.equals((Object)DAPR_TOPIC)) continue;
                    topic = annotation;
                }
                if (classPathOp.isPresent() || Objects.nonNull(methodPath)) {
                    Object path = "";
                    if (classPathOp.isPresent()) {
                        path = (String)path + classPathOp.get().value().asString();
                    }
                    if (StringUtils.isNotBlank(methodPath)) {
                        path = (String)path + methodPath;
                    }
                    ((String)path).replaceAll("//", "/");
                    String pubsubName = topic.value("pubsubName").asString();
                    String topicName = topic.value("name").asString();
                    try {
                        AnnotationValue metadataValue = topic.value("metadata");
                        HashMap<String, String> metadata = Objects.nonNull(metadataValue) ? (Map)objectMapper.readValue(metadataValue.asString(), MAP_TYPE) : new HashMap<String, String>();
                        topicProducer.produce((BuildItem)new DaprTopicBuildItem(pubsubName, topicName, (String)path, metadata));
                    }
                    catch (Exception e) {
                        log.error("dapr topic map to path error in class:{},topicName:{}", new Object[]{classInfo.name().toString(), topicName, e});
                    }
                }
            });
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void addTopic(DaprRuntimeRecorder daprRuntimeRecorder, List<DaprTopicBuildItem> daprTopicBuildItems) {
        for (DaprTopicBuildItem item : daprTopicBuildItems) {
            daprRuntimeRecorder.subscribeToTopics(item.getPubSubName(), item.getTopicName(), item.getRoute(), item.getMetadata());
        }
    }

    private RouteBuildItem getDaprRouteBuildItem(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, AbstractDaprHandler handler) {
        return nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(handler.baseRoute(), handler.subRoute()).handler((Handler)handler).displayOnNotFoundPage().build();
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildProducer) {
        reflectiveClassBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{DaprTopicSubscription.class, ActorRuntimeConfig.class}));
    }
}

