/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport.http.hc5;

import java.util.concurrent.Executor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.workqueue.AutomaticWorkQueue;

public class QuarkusWorkQueueImpl
implements AutomaticWorkQueue {
    private final String name;
    private final Executor executor;

    public QuarkusWorkQueueImpl(String name, Executor executor) {
        this.name = name;
        this.executor = executor;
    }

    public void execute(final Runnable command) {
        final ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ClassLoaderUtils.ClassLoaderHolder orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                try {
                    command.run();
                }
                finally {
                    if (orig != null) {
                        orig.reset();
                    }
                }
            }
        };
        this.executor.execute(r);
    }

    public void execute(Runnable work, long timeout) {
        this.execute(work);
    }

    public synchronized void schedule(Runnable work, long delay) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public void shutdown(boolean processRemainingWorkItems) {
    }

    public boolean isShutdown() {
        return false;
    }
}

