/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport.http.hc5;

import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.cxf.transport.http.asyncclient.hc5.AsyncHttpResponseWrapperFactory;
import org.apache.hc.core5.http.HttpResponse;
import org.eclipse.microprofile.context.ThreadContext;

public class QuarkusAsyncHttpResponseWrapperFactory
implements AsyncHttpResponseWrapperFactory {
    public AsyncHttpResponseWrapperFactory.AsyncHttpResponseWrapper create() {
        ThreadContext threadContext = (ThreadContext)Arc.container().select(ThreadContext.class, new Annotation[0]).get();
        BiConsumer contextualConsumer = threadContext.contextualConsumer((response, delegate) -> delegate.accept(response));
        return new MyAsyncResponseCallback(contextualConsumer);
    }

    public static class MyAsyncResponseCallback
    implements AsyncHttpResponseWrapperFactory.AsyncHttpResponseWrapper {
        final BiConsumer<HttpResponse, Consumer<HttpResponse>> contextualConsumer;

        public MyAsyncResponseCallback(BiConsumer<HttpResponse, Consumer<HttpResponse>> contextualConsumer) {
            this.contextualConsumer = contextualConsumer;
        }

        public void responseReceived(HttpResponse response, Consumer<HttpResponse> delegate) {
            this.contextualConsumer.accept(response, delegate);
        }
    }
}

