/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CxfClientProducer;
import io.quarkiverse.cxf.opentelemetry.CxfOpenTelemetryConfig;
import io.quarkiverse.cxf.transport.CxfHandler;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.tracing.opentelemetry.OpenTelemetryClientFeature;
import org.apache.cxf.tracing.opentelemetry.OpenTelemetryFeature;

@ApplicationScoped
public class OpenTelemetryCustomizer
implements CxfClientProducer.ClientFactoryCustomizer,
CxfHandler.EndpointFactoryCustomizer {
    public static final String INSTRUMENTATION_SCOPE = "io.quarkiverse.cxf";
    @Inject
    CxfOpenTelemetryConfig config;
    @Inject
    OpenTelemetry openTelemetry;
    private OpenTelemetryFeature serviceFeature;
    private OpenTelemetryClientFeature clientFeature;

    @PostConstruct
    void init() {
        this.serviceFeature = new OpenTelemetryFeature(this.openTelemetry, INSTRUMENTATION_SCOPE);
        this.clientFeature = new OpenTelemetryClientFeature(this.openTelemetry, INSTRUMENTATION_SCOPE);
    }

    public void customize(CXFClientInfo cxfClientInfo, JaxWsProxyFactoryBean factory) {
        if (this.config.otel().enabledFor().enabledForClients()) {
            String key = cxfClientInfo.getConfigKey();
            Map<String, CxfOpenTelemetryConfig.ClientsConfig> clients = this.config.clients();
            if (key == null || clients == null || !clients.containsKey(key) || clients.get(key).otel().enabled()) {
                factory.getFeatures().add(this.clientFeature);
            }
        }
    }

    public void customize(CXFServletInfo servletInfo, JaxWsServerFactoryBean factory) {
        if (this.config.otel().enabledFor().enabledForServices()) {
            String key = servletInfo.getRelativePath();
            Map<String, CxfOpenTelemetryConfig.EndpointsConfig> endpoints = this.config.endpoints();
            if (key == null || endpoints == null || !endpoints.containsKey(key) || endpoints.get(key).otel().enabled()) {
                factory.getFeatures().add(this.serviceFeature);
            }
        }
    }
}

