/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.wsdl2java.it;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.jboss.eap.quickstarts.wscalculator.calculator.Add;
import org.jboss.eap.quickstarts.wscalculator.calculator.ObjectFactory;
import org.jboss.eap.quickstarts.wscalculator.calculator.Operands;
import org.jboss.eap.quickstarts.wscalculator.calculator.Result;
import org.junit.jupiter.api.Test;

public class Wsdl2JavaTest {
    @Test
    void codegenTests() throws IOException {
        Path calculatorService_Service = Paths.get("target/generated-test-sources/wsdl2java/org/jboss/eap/quickstarts/wscalculator/calculator/CalculatorService_Service.java", new String[0]);
        Assertions.assertThat((Path)calculatorService_Service).isRegularFile().content(StandardCharsets.UTF_8).contains(new CharSequence[]{"wsdlLocation = \"classpath:wsdl/CalculatorService.wsdl\""});
    }

    @Test
    void generatedCodeCompiled() {
        ObjectFactory of = new ObjectFactory();
        Add add = of.createAdd();
        Assertions.assertThat((Object)add).isNotNull();
    }

    @Test
    void toStringGenerated() {
        Operands op = new Operands();
        op.setA(1);
        op.setB(2);
        Assertions.assertThat((String)op.toString()).contains(new CharSequence[]{"a=1,b=2"});
    }

    @Test
    void propertyListenerGenerated() {
        Operands op = new Operands();
        ArrayList events = new ArrayList();
        op.addPropertyChangeListener(events::add);
        op.setA(1);
        op.setB(2);
        Assertions.assertThat(events).hasSize(2);
        PropertyChangeEvent e0 = (PropertyChangeEvent)events.get(0);
        Assertions.assertThat((String)e0.getPropertyName()).isEqualTo("a");
        Assertions.assertThat((Object)e0.getNewValue()).isEqualTo((Object)1);
        PropertyChangeEvent e1 = (PropertyChangeEvent)events.get(1);
        Assertions.assertThat((String)e1.getPropertyName()).isEqualTo("b");
        Assertions.assertThat((Object)e1.getNewValue()).isEqualTo((Object)2);
    }

    @Test
    void defaultGenerated() {
        Result result = new Result();
        Assertions.assertThat((String)result.getTheAnswer()).isEqualTo("42");
        result.setTheAnswer("43");
        Assertions.assertThat((String)result.getTheAnswer()).isEqualTo("43");
    }

    @Test
    void javadocGenerated() {
        Path calculatorService_Service = Paths.get("target/generated-test-sources/wsdl2java/org/jboss/eap/quickstarts/wscalculator/calculator/Result.java", new String[0]);
        Assertions.assertThat((Path)calculatorService_Service).isRegularFile().content(StandardCharsets.UTF_8).contains(new CharSequence[]{"This text should appear in JavaDoc of result"});
    }

    @Test
    void getBooleanGenerated() {
        Path calculatorService_Service = Paths.get("target/generated-test-sources/wsdl2java/org/jboss/eap/quickstarts/wscalculator/calculator/Result.java", new String[0]);
        Assertions.assertThat((Path)calculatorService_Service).isRegularFile().content(StandardCharsets.UTF_8).contains(new CharSequence[]{"public boolean getEven() {"});
    }

    @Test
    void extensibilityElementGenerated() {
        Path calculatorService_Service = Paths.get("target/generated-test-sources/wsdl2java/org/jboss/eap/quickstarts/wscalculator/calculator/Result.java", new String[0]);
        Assertions.assertThat((Path)calculatorService_Service).isRegularFile().content(StandardCharsets.UTF_8).contains(new CharSequence[]{"implements ExtensibilityElement"});
    }
}

