/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cucumber;

import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.plugin.PrettyFormatter;
import io.cucumber.core.runner.Runner;
import io.cucumber.core.runtime.CucumberExecutionContext;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.ScanningTypeRegistryConfigurerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.java.JavaBackendProviderService;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestStepFinished;
import io.quarkiverse.cucumber.QuarkusCucumberOptionsProvider;
import io.quarkus.test.junit.QuarkusTest;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.time.Clock;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;

@QuarkusTest
public abstract class CucumberQuarkusTest {
    @TestFactory
    List<DynamicNode> getTests() {
        RuntimeOptions runtimeOptions;
        TimeServiceEventBus eventBus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        FeatureParser parser = new FeatureParser(() -> ((EventBus)eventBus).generateId());
        RuntimeOptions propertiesFileOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromPropertiesFile()).build();
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).build(propertiesFileOptions);
        RuntimeOptions systemOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).build(environmentOptions);
        RuntimeOptionsBuilder runtimeOptionsBuilder = new RuntimeOptionsBuilder().addDefaultFeaturePathIfAbsent().addDefaultGlueIfAbsent().addDefaultFormatterIfAbsent().addDefaultSummaryPrinterIfAbsent();
        QuarkusCucumberOptionsProvider optionsProvider = new QuarkusCucumberOptionsProvider();
        if (optionsProvider.hasOptions(this.getClass())) {
            CucumberOptionsAnnotationParser annotationParser = new CucumberOptionsAnnotationParser().withOptionsProvider((CucumberOptionsAnnotationParser.OptionsProvider)optionsProvider);
            RuntimeOptions annotationOptions = annotationParser.parse(this.getClass()).build(systemOptions);
            runtimeOptions = runtimeOptionsBuilder.build(annotationOptions);
        } else {
            runtimeOptions = runtimeOptionsBuilder.build(systemOptions);
        }
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(() -> Thread.currentThread().getContextClassLoader(), (io.cucumber.core.feature.Options)runtimeOptions, parser);
        Plugins plugins = new Plugins(new PluginFactory(), (Options)runtimeOptions);
        plugins.addPlugin((Plugin)new PrettyFormatter((OutputStream)System.out));
        ExitStatus exitStatus = new ExitStatus((Options)runtimeOptions);
        plugins.addPlugin((Plugin)exitStatus);
        if (runtimeOptions.isMultiThreaded()) {
            plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)eventBus);
        } else {
            plugins.setEventBusOnEventListenerPlugins((EventPublisher)eventBus);
        }
        CdiObjectFactory objectFactory = new CdiObjectFactory();
        ObjectFactorySupplier objectFactorySupplier = () -> objectFactory;
        ScanningTypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier = new ScanningTypeRegistryConfigurerSupplier(() -> Thread.currentThread().getContextClassLoader(), (io.cucumber.core.runner.Options)runtimeOptions);
        Runner runner = new Runner((EventBus)eventBus, Collections.singleton(new JavaBackendProviderService().create((Lookup)objectFactorySupplier.get(), (Container)objectFactorySupplier.get(), () -> Thread.currentThread().getContextClassLoader())), objectFactorySupplier.get(), typeRegistryConfigurerSupplier.get(), (io.cucumber.core.runner.Options)runtimeOptions);
        CucumberExecutionContext context = new CucumberExecutionContext((EventBus)eventBus, exitStatus, () -> runner);
        LinkedList<DynamicNode> features = new LinkedList<DynamicNode>();
        features.add((DynamicNode)DynamicTest.dynamicTest((String)"Start Cucumber", () -> ((CucumberExecutionContext)context).startTestRun()));
        featureSupplier.get().forEach(arg_0 -> CucumberQuarkusTest.lambda$getTests$10(context, (EventBus)eventBus, features, arg_0));
        features.add((DynamicNode)DynamicTest.dynamicTest((String)"Finish Cucumber", () -> ((CucumberExecutionContext)context).finishTestRun()));
        return features;
    }

    private static /* synthetic */ void lambda$getTests$10(CucumberExecutionContext context, EventBus eventBus, List features, Feature f) {
        LinkedList<DynamicTest> tests = new LinkedList<DynamicTest>();
        tests.add(DynamicTest.dynamicTest((String)"Start Feature", () -> context.beforeFeature(f)));
        f.getPickles().forEach(p -> tests.add(DynamicTest.dynamicTest((String)p.getName(), () -> {
            AtomicReference resultAtomicReference = new AtomicReference();
            EventHandler handler = event -> {
                if (event.getResult().getStatus() != Status.PASSED) {
                    resultAtomicReference.compareAndSet(null, event);
                }
            };
            eventBus.registerHandlerFor(TestStepFinished.class, handler);
            context.runTestCase(r -> r.runPickle(p));
            eventBus.removeHandlerFor(TestStepFinished.class, handler);
            if (resultAtomicReference.get() != null) {
                Assertions.fail((String)("failed in " + f.getUri() + " at line " + ((PickleStepTestStep)((TestStepFinished)resultAtomicReference.get()).getTestStep()).getStep().getLocation().getLine()), (Throwable)((TestStepFinished)resultAtomicReference.get()).getResult().getError());
            }
        })));
        features.add(DynamicContainer.dynamicContainer((String)f.getName().orElse(f.getSource()), tests.stream()));
    }

    public static class CdiObjectFactory
    implements ObjectFactory {
        public void start() {
        }

        public void stop() {
        }

        public boolean addClass(Class<?> clazz) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T getInstance(Class<T> type) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(type.getClassLoader());
                Instance selected = CDI.current().select(type, new Annotation[0]);
                if (selected.isUnsatisfied()) {
                    throw new IllegalArgumentException(type.getName() + " is no CDI bean.");
                }
                Object object = selected.get();
                return (T)object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

