/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.businessscore.runtime;

import io.quarkiverse.businessscore.BusinessScore;
import io.quarkiverse.businessscore.runtime.BusinessScoreConfig;
import io.quarkus.runtime.Startup;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class BusinessScoreImpl
implements BusinessScore {
    private static final Logger LOG = Logger.getLogger(BusinessScoreImpl.class);
    private final Lock lock = new ReentrantLock();
    private final List<BusinessScore.Score> records = new ArrayList<BusinessScore.Score>();
    private final AtomicLong zombieThreshold;
    private final AtomicReference<Duration> timeWindow;
    private final long startTime;
    private final int autoCompactLimit;

    BusinessScoreImpl(BusinessScoreConfig config) {
        this.zombieThreshold = new AtomicLong(config.zombieThreshold());
        this.timeWindow = new AtomicReference<Duration>(config.timeWindow());
        this.startTime = System.currentTimeMillis();
        this.autoCompactLimit = config.autoCompactLimit();
    }

    @Override
    public void score(int value, String ... labels) {
        if (value <= 0) {
            throw new IllegalArgumentException("Score value must be positive: " + value);
        }
        this.lock.lock();
        try {
            if (this.records.size() > this.autoCompactLimit) {
                this.tryCompact();
            }
            this.records.add(new BusinessScore.Score(value, System.currentTimeMillis(), Set.of(labels)));
        }
        finally {
            this.lock.unlock();
        }
        LOG.debugf("Scored {} [labels: {}]", value, (Object)(labels.length > 0 ? Arrays.toString(labels) : "[]"));
    }

    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.records.clear();
        }
        finally {
            this.lock.unlock();
        }
        LOG.debugf("The score has been reset", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCurrent() {
        int total = 0;
        long now = System.currentTimeMillis();
        long timeWindow = this.timeWindow.get().toMillis();
        this.lock.lock();
        try {
            BusinessScore.Score score;
            ListIterator<BusinessScore.Score> it = this.records.listIterator(this.records.size());
            while (it.hasPrevious() && this.isInWindow(score = it.previous(), now, timeWindow)) {
                total += score.value();
            }
        }
        finally {
            this.lock.unlock();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryCompact() {
        long start = System.nanoTime();
        int removed = 0;
        long now = System.currentTimeMillis();
        long timeWindow = this.timeWindow.get().toMillis();
        this.lock.lock();
        try {
            Iterator<BusinessScore.Score> it = this.records.iterator();
            while (it.hasNext() && !this.isInWindow(it.next(), now, timeWindow)) {
                it.remove();
                ++removed;
            }
        }
        finally {
            this.lock.unlock();
        }
        LOG.debugf("Done compacting in %s ms (removed %s records)", System.nanoTime() - start, (long)removed);
        return removed;
    }

    @Override
    public long getZombieThreshold() {
        return this.zombieThreshold.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BusinessScore.ZombieStatus test() {
        long now = System.currentTimeMillis();
        boolean didRunLongEnough = now - this.startTime >= this.timeWindow.get().toMillis();
        int total = 0;
        Duration timeWindow = this.timeWindow.get();
        long timeWindowMillis = timeWindow.toMillis();
        long threshold = this.zombieThreshold.get();
        this.lock.lock();
        try {
            BusinessScore.Score score;
            ListIterator<BusinessScore.Score> it = this.records.listIterator(this.records.size());
            while (it.hasPrevious() && this.isInWindow(score = it.previous(), now, timeWindowMillis)) {
                total += score.value();
            }
        }
        finally {
            this.lock.unlock();
        }
        return new BusinessScore.ZombieStatus(didRunLongEnough ? (long)total < threshold : false, total, threshold, timeWindow);
    }

    private boolean isInWindow(BusinessScore.Score score, long now, long timeWindow) {
        return now - score.timestamp() < timeWindow;
    }

    @Override
    public void setZombieThreshold(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("Zombie threshold value must be positive: " + value);
        }
        this.zombieThreshold.set(value);
    }

    @Override
    public Duration getTimeWindow() {
        return this.timeWindow.get();
    }

    @Override
    public void setTimeWindow(Duration value) {
        this.timeWindow.set(Objects.requireNonNull(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BusinessScore.Score> getCurrentRecords() {
        ArrayList<BusinessScore.Score> ret = new ArrayList<BusinessScore.Score>(this.records.size());
        long now = System.currentTimeMillis();
        long timeWindow = this.timeWindow.get().toMillis();
        this.lock.lock();
        try {
            for (BusinessScore.Score record : this.records) {
                if (!this.isInWindow(record, now, timeWindow)) continue;
                ret.add(record);
            }
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }
}

