/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.generator.input;

import io.quarkiverse.asyncapi.config.AsyncAPIExtension;
import io.quarkiverse.asyncapi.generator.AsyncApiCodeGenerator;
import io.quarkiverse.asyncapi.generator.input.AsyncAPISpecInput;
import io.quarkiverse.asyncapi.generator.input.AsyncApiGeneratorCodeGenBase;
import io.quarkiverse.asyncapi.generator.input.AsyncApiSpecInputProvider;
import io.quarkiverse.asyncapi.generator.input.InputStreamSupplier;
import io.quarkus.deployment.CodeGenContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.Config;

public class AsyncApiGeneratorStreamCodeGen
extends AsyncApiGeneratorCodeGenBase {
    private Map<AsyncApiCodeGenerator, Map<String, InputStreamSupplier>> generators;
    private final ServiceLoader<AsyncApiSpecInputProvider> providers = ServiceLoader.load(AsyncApiSpecInputProvider.class);

    public AsyncApiGeneratorStreamCodeGen() {
        super(AsyncAPIExtension.stream);
    }

    @Override
    protected Collection<AsyncApiCodeGenerator> buildCodeGenerators(CodeGenContext context) {
        this.generators = new HashMap<AsyncApiCodeGenerator, Map<String, InputStreamSupplier>>();
        for (AsyncApiSpecInputProvider provider : this.providers) {
            AsyncAPISpecInput specInput = provider.read(context);
            this.generators.put(new AsyncApiCodeGenerator(context.outDir(), context.config(), Optional.ofNullable(specInput.getBasePackage())), specInput.getStreams());
        }
        return this.generators.keySet();
    }

    @Override
    public void trigger(CodeGenContext context, AsyncApiCodeGenerator generator) throws IOException {
        for (Map.Entry<String, InputStreamSupplier> entry : this.generators.get(generator).entrySet()) {
            InputStream is = entry.getValue().get();
            try {
                generator.generate(entry.getKey(), is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    public boolean shouldRun(Path sourceDir, Config config) {
        return this.providers.findFirst().isPresent();
    }
}

