/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.generator.input;

import io.quarkiverse.asyncapi.config.AsyncAPIExtension;
import io.quarkiverse.asyncapi.generator.AsyncApiCodeGenerator;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import java.io.IOException;
import java.util.Collection;

public abstract class AsyncApiGeneratorCodeGenBase
implements CodeGenProvider {
    protected final AsyncAPIExtension extension;
    private static final String ASYNC_API = "asyncapi";

    protected AsyncApiGeneratorCodeGenBase(AsyncAPIExtension extension) {
        this.extension = extension;
    }

    public String providerId() {
        return "asyncapi-" + this.inputExtension();
    }

    public String inputDirectory() {
        return ASYNC_API;
    }

    public String inputExtension() {
        return this.extension.toString();
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        boolean result = false;
        for (AsyncApiCodeGenerator generator : this.buildCodeGenerators(context)) {
            try {
                this.trigger(context, generator);
                result |= generator.done(context.test());
            }
            catch (IOException io) {
                throw new CodeGenException((Throwable)io);
            }
        }
        return result;
    }

    protected abstract Collection<AsyncApiCodeGenerator> buildCodeGenerators(CodeGenContext var1);

    protected abstract void trigger(CodeGenContext var1, AsyncApiCodeGenerator var2) throws IOException;
}

