package io.qt.xmlpatterns;


/**
 * <p>Performs XQueries on XML data, or on non-XML data modeled to look like XML</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qxmlquery.html">QXmlQuery</a></p>
 */
public class QXmlQuery extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcNetworkAccessManager = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcMessageHandler = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcFocusDevice = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcUriResolver = null;
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qxmlquery.html#QueryLanguage-enum">QXmlQuery::QueryLanguage</a></p>
     */
    public enum QueryLanguage implements io.qt.QtEnumerator {
        XQuery10(1),
        XSLT20(2),
        XmlSchema11IdentityConstraintSelector(1024),
        XmlSchema11IdentityConstraintField(2048),
        XPath20(4096);

        private QueryLanguage(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static QueryLanguage resolve(int value) {
            switch (value) {
            case 1: return XQuery10;
            case 2: return XSLT20;
            case 1024: return XmlSchema11IdentityConstraintSelector;
            case 2048: return XmlSchema11IdentityConstraintField;
            case 4096: return XPath20;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery">QXmlQuery::QXmlQuery()</a></p>
     */
    public QXmlQuery(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlQuery instance);
    
    /**
     * <p>Overloaded constructor for {@link #QXmlQuery(io.qt.xmlpatterns.QXmlQuery.QueryLanguage, io.qt.xmlpatterns.QXmlNamePool)}
     *  with <code>np = new io.qt.xmlpatterns.QXmlNamePool()</code>.</p>
     */
    public QXmlQuery(io.qt.xmlpatterns.QXmlQuery.QueryLanguage queryLanguage) {
        this(queryLanguage, new io.qt.xmlpatterns.QXmlNamePool());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-3">QXmlQuery::QXmlQuery(QXmlQuery::QueryLanguage,QXmlNamePool)</a></p>
     */
    public QXmlQuery(io.qt.xmlpatterns.QXmlQuery.QueryLanguage queryLanguage, io.qt.xmlpatterns.QXmlNamePool np){
        super((QPrivateConstructor)null);
        initialize_native(this, queryLanguage, np);
    }
    
    private native static void initialize_native(QXmlQuery instance, io.qt.xmlpatterns.QXmlQuery.QueryLanguage queryLanguage, io.qt.xmlpatterns.QXmlNamePool np);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-2">QXmlQuery::QXmlQuery(QXmlNamePool)</a></p>
     */
    public QXmlQuery(io.qt.xmlpatterns.QXmlNamePool np){
        super((QPrivateConstructor)null);
        initialize_native(this, np);
    }
    
    private native static void initialize_native(QXmlQuery instance, io.qt.xmlpatterns.QXmlNamePool np);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-1">QXmlQuery::QXmlQuery(QXmlQuery)</a></p>
     */
    public QXmlQuery(io.qt.xmlpatterns.QXmlQuery other){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QXmlQuery instance, io.qt.xmlpatterns.QXmlQuery other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-3">QXmlQuery::bindVariable(QString,QIODevice*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindVariable(java.lang.String localName, io.qt.core.QIODevice arg__2){
        bindVariable_native_cref_QString_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), localName, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @io.qt.QtUninvokable
    private native void bindVariable_native_cref_QString_QIODevice_ptr(long __this__nativeId, java.lang.String localName, long arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-1">QXmlQuery::bindVariable(QString,QXmlItem)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindVariable(java.lang.String localName, io.qt.xmlpatterns.QXmlItem value){
        bindVariable_native_cref_QString_cref_QXmlItem(QtJambi_LibraryUtilities.internal.nativeId(this), localName, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void bindVariable_native_cref_QString_cref_QXmlItem(long __this__nativeId, java.lang.String localName, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-5">QXmlQuery::bindVariable(QString,QXmlQuery)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindVariable(java.lang.String localName, io.qt.xmlpatterns.QXmlQuery query){
        java.util.Objects.requireNonNull(query, "Argument 'query': null not expected.");
        bindVariable_native_cref_QString_cref_QXmlQuery(QtJambi_LibraryUtilities.internal.nativeId(this), localName, QtJambi_LibraryUtilities.internal.checkedNativeId(query));
    }
    
    @io.qt.QtUninvokable
    private native void bindVariable_native_cref_QString_cref_QXmlQuery(long __this__nativeId, java.lang.String localName, long query);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-2">QXmlQuery::bindVariable(QXmlName,QIODevice*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindVariable(io.qt.xmlpatterns.QXmlName name, io.qt.core.QIODevice arg__2){
        bindVariable_native_cref_QXmlName_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @io.qt.QtUninvokable
    private native void bindVariable_native_cref_QXmlName_QIODevice_ptr(long __this__nativeId, long name, long arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable">QXmlQuery::bindVariable(QXmlName,QXmlItem)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindVariable(io.qt.xmlpatterns.QXmlName name, io.qt.xmlpatterns.QXmlItem value){
        bindVariable_native_cref_QXmlName_cref_QXmlItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void bindVariable_native_cref_QXmlName_cref_QXmlItem(long __this__nativeId, long name, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-4">QXmlQuery::bindVariable(QXmlName,QXmlQuery)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindVariable(io.qt.xmlpatterns.QXmlName name, io.qt.xmlpatterns.QXmlQuery query){
        java.util.Objects.requireNonNull(query, "Argument 'query': null not expected.");
        bindVariable_native_cref_QXmlName_cref_QXmlQuery(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(query));
    }
    
    @io.qt.QtUninvokable
    private native void bindVariable_native_cref_QXmlName_cref_QXmlQuery(long __this__nativeId, long name, long query);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-1">QXmlQuery::evaluateTo(QAbstractXmlReceiver*)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean evaluateTo(io.qt.xmlpatterns.QAbstractXmlReceiver callback){
        java.util.Objects.requireNonNull(callback, "Argument 'callback': null not expected.");
        return evaluateTo_native_QAbstractXmlReceiver_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(callback));
    }
    
    @io.qt.QtUninvokable
    private native boolean evaluateTo_native_QAbstractXmlReceiver_ptr_constfct(long __this__nativeId, long callback);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-3">QXmlQuery::evaluateTo(QIODevice*)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean evaluateTo(io.qt.core.QIODevice target){
        java.util.Objects.requireNonNull(target, "Argument 'target': null not expected.");
        return evaluateTo_native_QIODevice_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
    }
    
    @io.qt.QtUninvokable
    private native boolean evaluateTo_native_QIODevice_ptr_constfct(long __this__nativeId, long target);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-4">QXmlQuery::evaluateTo(QString*)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String evaluateToString(){
        return evaluateToString_native_QString_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String evaluateToString_native_QString_ptr_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-2">QXmlQuery::evaluateTo(QStringList*)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean evaluateTo(java.util.Collection<java.lang.String> target){
        java.util.Objects.requireNonNull(target, "Argument 'target': null not expected.");
        return evaluateTo_native_QStringList_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native boolean evaluateTo_native_QStringList_ptr_constfct(long __this__nativeId, java.util.Collection<java.lang.String> target);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo">QXmlQuery::evaluateTo(QXmlResultItems*)const</a></p>
     */
    @io.qt.QtUninvokable
    public final void evaluateTo(io.qt.xmlpatterns.QXmlResultItems result){
        java.util.Objects.requireNonNull(result, "Argument 'result': null not expected.");
        evaluateTo_native_QXmlResultItems_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(result));
    }
    
    @io.qt.QtUninvokable
    private native void evaluateTo_native_QXmlResultItems_ptr_constfct(long __this__nativeId, long result);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#initialTemplateName">QXmlQuery::initialTemplateName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xmlpatterns.QXmlName initialTemplateName(){
        return initialTemplateName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xmlpatterns.QXmlName initialTemplateName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#isValid">QXmlQuery::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#messageHandler">QXmlQuery::messageHandler()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xmlpatterns.QAbstractMessageHandler messageHandler(){
        return messageHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xmlpatterns.QAbstractMessageHandler messageHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#namePool">QXmlQuery::namePool()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xmlpatterns.QXmlNamePool namePool(){
        return namePool_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xmlpatterns.QXmlNamePool namePool_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#networkAccessManager">QXmlQuery::networkAccessManager()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.network.QNetworkAccessManager networkAccessManager(){
        return networkAccessManager_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkAccessManager networkAccessManager_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#operator-eq">QXmlQuery::operator=(QXmlQuery)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xmlpatterns.QXmlQuery set(io.qt.xmlpatterns.QXmlQuery other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        set_native_cref_QXmlQuery(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        return this;
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xmlpatterns.QXmlQuery set_native_cref_QXmlQuery(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#queryLanguage">QXmlQuery::queryLanguage()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xmlpatterns.QXmlQuery.QueryLanguage queryLanguage(){
        return io.qt.xmlpatterns.QXmlQuery.QueryLanguage.resolve(queryLanguage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int queryLanguage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setFocus-2">QXmlQuery::setFocus(QIODevice*)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setFocus(io.qt.core.QIODevice document){
        boolean __qt_return_value = setFocus_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(document));
        __rcFocusDevice = document;
        return __qt_return_value;
    }
    
    @io.qt.QtUninvokable
    private native boolean setFocus_native_QIODevice_ptr(long __this__nativeId, long document);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setFocus-3">QXmlQuery::setFocus(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setFocus(java.lang.String focus){
        return setFocus_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), focus);
    }
    
    @io.qt.QtUninvokable
    private native boolean setFocus_native_cref_QString(long __this__nativeId, java.lang.String focus);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setFocus-1">QXmlQuery::setFocus(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean setFocus(io.qt.core.QUrl documentURI){
        return setFocus_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(documentURI));
    }
    
    @io.qt.QtUninvokable
    private native boolean setFocus_native_cref_QUrl(long __this__nativeId, long documentURI);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setFocus">QXmlQuery::setFocus(QXmlItem)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFocus(io.qt.xmlpatterns.QXmlItem item){
        setFocus_native_cref_QXmlItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @io.qt.QtUninvokable
    private native void setFocus_native_cref_QXmlItem(long __this__nativeId, long item);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setInitialTemplateName-1">QXmlQuery::setInitialTemplateName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setInitialTemplateName(java.lang.String name){
        setInitialTemplateName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setInitialTemplateName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setInitialTemplateName">QXmlQuery::setInitialTemplateName(QXmlName)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setInitialTemplateName(io.qt.xmlpatterns.QXmlName name){
        setInitialTemplateName_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @io.qt.QtUninvokable
    private native void setInitialTemplateName_native_cref_QXmlName(long __this__nativeId, long name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setMessageHandler">QXmlQuery::setMessageHandler(QAbstractMessageHandler*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMessageHandler(io.qt.xmlpatterns.QAbstractMessageHandler messageHandler){
        setMessageHandler_native_QAbstractMessageHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(messageHandler));
        __rcMessageHandler = messageHandler;
    }
    
    @io.qt.QtUninvokable
    private native void setMessageHandler_native_QAbstractMessageHandler_ptr(long __this__nativeId, long messageHandler);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setNetworkAccessManager">QXmlQuery::setNetworkAccessManager(QNetworkAccessManager*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setNetworkAccessManager(io.qt.network.QNetworkAccessManager newManager){
        setNetworkAccessManager_native_QNetworkAccessManager_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newManager));
        __rcNetworkAccessManager = newManager;
    }
    
    @io.qt.QtUninvokable
    private native void setNetworkAccessManager_native_QNetworkAccessManager_ptr(long __this__nativeId, long newManager);
    
    /**
     * <p>Overloaded function for {@link #setQuery(io.qt.core.QIODevice, io.qt.core.QUrl)}
     *  with <code>documentURI = new io.qt.core.QUrl()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setQuery(io.qt.core.QIODevice sourceCode) {
        setQuery(sourceCode, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setQuery">QXmlQuery::setQuery(QIODevice*,QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setQuery(io.qt.core.QIODevice sourceCode, io.qt.core.QUrl documentURI){
        setQuery_native_QIODevice_ptr_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceCode), QtJambi_LibraryUtilities.internal.checkedNativeId(documentURI));
    }
    
    @io.qt.QtUninvokable
    private native void setQuery_native_QIODevice_ptr_cref_QUrl(long __this__nativeId, long sourceCode, long documentURI);
    
    /**
     * <p>Overloaded function for {@link #setQuery(java.lang.String, io.qt.core.QUrl)}
     *  with <code>documentURI = new io.qt.core.QUrl()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setQuery(java.lang.String sourceCode) {
        setQuery(sourceCode, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setQuery-1">QXmlQuery::setQuery(QString,QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setQuery(java.lang.String sourceCode, io.qt.core.QUrl documentURI){
        setQuery_native_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), sourceCode, QtJambi_LibraryUtilities.internal.checkedNativeId(documentURI));
    }
    
    @io.qt.QtUninvokable
    private native void setQuery_native_cref_QString_cref_QUrl(long __this__nativeId, java.lang.String sourceCode, long documentURI);
    
    /**
     * <p>Overloaded function for {@link #setQuery(io.qt.core.QUrl, io.qt.core.QUrl)}
     *  with <code>baseURI = new io.qt.core.QUrl()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setQuery(io.qt.core.QUrl queryURI) {
        setQuery(queryURI, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setQuery-2">QXmlQuery::setQuery(QUrl,QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setQuery(io.qt.core.QUrl queryURI, io.qt.core.QUrl baseURI){
        setQuery_native_cref_QUrl_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(queryURI), QtJambi_LibraryUtilities.internal.checkedNativeId(baseURI));
    }
    
    @io.qt.QtUninvokable
    private native void setQuery_native_cref_QUrl_cref_QUrl(long __this__nativeId, long queryURI, long baseURI);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#setUriResolver">QXmlQuery::setUriResolver(const QAbstractUriResolver*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUriResolver(io.qt.xmlpatterns.QAbstractUriResolver resolver){
        setUriResolver_native_const_QAbstractUriResolver_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(resolver));
        __rcUriResolver = resolver;
    }
    
    @io.qt.QtUninvokable
    private native void setUriResolver_native_const_QAbstractUriResolver_ptr(long __this__nativeId, long resolver);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlquery.html#uriResolver">QXmlQuery::uriResolver()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xmlpatterns.QAbstractUriResolver uriResolver(){
        return uriResolver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xmlpatterns.QAbstractUriResolver uriResolver_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QXmlQuery(QPrivateConstructor p) { super(p); } 
    
}
