package io.qt.xmlpatterns;


/**
 * <p>Identifies a location in a resource by URI, line, and column</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsourcelocation.html">QSourceLocation</a></p>
 */
public class QSourceLocation extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#QSourceLocation">QSourceLocation::QSourceLocation()</a></p>
     */
    public QSourceLocation(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSourceLocation instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#QSourceLocation-1">QSourceLocation::QSourceLocation(QSourceLocation)</a></p>
     */
    public QSourceLocation(io.qt.xmlpatterns.QSourceLocation other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSourceLocation instance, io.qt.xmlpatterns.QSourceLocation other);
    
    /**
     * <p>Overloaded constructor for {@link #QSourceLocation(io.qt.core.QUrl, int, int)}
     *  with <code>column = -1</code>.</p>
     */
    public QSourceLocation(io.qt.core.QUrl uri, int line) {
        this(uri, line, (int)-1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSourceLocation(io.qt.core.QUrl, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>line = -1</code></li>
     * <li><code>column = -1</code></li>
     * </ul>
     */
    public QSourceLocation(io.qt.core.QUrl uri) {
        this(uri, (int)-1, (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#QSourceLocation-2">QSourceLocation::QSourceLocation(QUrl,int,int)</a></p>
     */
    public QSourceLocation(io.qt.core.QUrl uri, int line, int column){
        super((QPrivateConstructor)null);
        initialize_native(this, uri, line, column);
    }
    
    private native static void initialize_native(QSourceLocation instance, io.qt.core.QUrl uri, int line, int column);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#column">QSourceLocation::column()const</a></p>
     */
    @io.qt.QtUninvokable
    public final long column(){
        return column_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long column_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#isNull">QSourceLocation::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#line">QSourceLocation::line()const</a></p>
     */
    @io.qt.QtUninvokable
    public final long line(){
        return line_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long line_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#operator-eq-eq">QSourceLocation::operator==(QSourceLocation)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.xmlpatterns.QSourceLocation other){
        return operator_equal_native_cref_QSourceLocation_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QSourceLocation_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#setColumn">QSourceLocation::setColumn(qint64)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setColumn(long newColumn){
        setColumn_native_long_long(QtJambi_LibraryUtilities.internal.nativeId(this), newColumn);
    }
    
    @io.qt.QtUninvokable
    private native void setColumn_native_long_long(long __this__nativeId, long newColumn);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#setLine">QSourceLocation::setLine(qint64)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setLine(long newLine){
        setLine_native_long_long(QtJambi_LibraryUtilities.internal.nativeId(this), newLine);
    }
    
    @io.qt.QtUninvokable
    private native void setLine_native_long_long(long __this__nativeId, long newLine);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#setUri">QSourceLocation::setUri(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUri(io.qt.core.QUrl newUri){
        setUri_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newUri));
    }
    
    @io.qt.QtUninvokable
    private native void setUri_native_cref_QUrl(long __this__nativeId, long newUri);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsourcelocation.html#uri">QSourceLocation::uri()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl uri(){
        return uri_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl uri_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSourceLocation(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xmlpatterns.QSourceLocation) {
            return operator_equal((io.qt.xmlpatterns.QSourceLocation) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @Override
    public QSourceLocation clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QSourceLocation clone_native(long __this_nativeId);
}
