package io.qt.xmlpatterns;


/**
 * <p>Callback interface for resolving Uniform Resource Identifiers. A Uniform Resource Identifier (URI) is a string that uniquely identifies a resource. URIs are versatile global identifiers. It is often useful to transform a URI that identifies something logical into a URI that locates something physical (a URL), or to simply map a URI to a different URI. QAbstractUriResolver::resolve() provides this functionality</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qabstracturiresolver.html">QAbstractUriResolver</a></p>
 */
public abstract class QAbstractUriResolver extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractUriResolver.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QAbstractUriResolver {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QUrl resolve(io.qt.core.QUrl relative, io.qt.core.QUrl baseURI){
            return resolve_native_cref_QUrl_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(relative), QtJambi_LibraryUtilities.internal.checkedNativeId(baseURI));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QUrl resolve_native_cref_QUrl_cref_QUrl_constfct(long __this__nativeId, long relative, long baseURI);
        
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractUriResolver(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractUriResolver() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstracturiresolver.html#QAbstractUriResolver">QAbstractUriResolver::QAbstractUriResolver(QObject*)</a></p>
     */
    public QAbstractUriResolver(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractUriResolver instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstracturiresolver.html#resolve">QAbstractUriResolver::resolve(QUrl,QUrl)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QUrl resolve(io.qt.core.QUrl relative, io.qt.core.QUrl baseURI);
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl resolve_native_cref_QUrl_cref_QUrl_constfct(long __this__nativeId, long relative, long baseURI);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractUriResolver(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAbstractUriResolver(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAbstractUriResolver instance, QDeclarativeConstructor constructor);
    
}
