package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Identifies a node in an XML node model subclassed from QAbstractXmlNodeModel</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html">QXmlNodeModelIndex</a></code></p>
 */
public class QXmlNodeModelIndex extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#DocumentOrder-enum">QXmlNodeModelIndex::DocumentOrder</a></code></p>
     */
    public enum DocumentOrder implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#DocumentOrder-enum">QXmlNodeModelIndex::<wbr/>Precedes</a></code></p>
         */
        Precedes(-1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#DocumentOrder-enum">QXmlNodeModelIndex::<wbr/>Is</a></code></p>
         */
        Is(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#DocumentOrder-enum">QXmlNodeModelIndex::<wbr/>Follows</a></code></p>
         */
        Follows(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DocumentOrder(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DocumentOrder resolve(int value) {
            switch (value) {
            case -1: return Precedes;
            case 0: return Is;
            case 1: return Follows;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#NodeKind-enum">QXmlNodeModelIndex::NodeKind</a></code></p>
     */
    public enum NodeKind implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#NodeKind-enum">QXmlNodeModelIndex::<wbr/>Attribute</a></code></p>
         */
        Attribute(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#NodeKind-enum">QXmlNodeModelIndex::<wbr/>Comment</a></code></p>
         */
        Comment(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#NodeKind-enum">QXmlNodeModelIndex::<wbr/>Document</a></code></p>
         */
        Document(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#NodeKind-enum">QXmlNodeModelIndex::<wbr/>Element</a></code></p>
         */
        Element(8),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#NodeKind-enum">QXmlNodeModelIndex::<wbr/>Namespace</a></code></p>
         */
        Namespace(16),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#NodeKind-enum">QXmlNodeModelIndex::<wbr/>ProcessingInstruction</a></code></p>
         */
        ProcessingInstruction(32),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#NodeKind-enum">QXmlNodeModelIndex::<wbr/>Text</a></code></p>
         */
        Text(64);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NodeKind(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NodeKind resolve(int value) {
            switch (value) {
            case 1: return Attribute;
            case 2: return Comment;
            case 4: return Document;
            case 8: return Element;
            case 16: return Namespace;
            case 32: return ProcessingInstruction;
            case 64: return Text;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#QXmlNodeModelIndex">QXmlNodeModelIndex::<wbr/>QXmlNodeModelIndex()</a></code></p>
     */
    public QXmlNodeModelIndex(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlNodeModelIndex instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#QXmlNodeModelIndex-1">QXmlNodeModelIndex::<wbr/>QXmlNodeModelIndex(QXmlNodeModelIndex)</a></code></p>
     */
    public QXmlNodeModelIndex(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QXmlNodeModelIndex instance, io.qt.xmlpatterns.QXmlNodeModelIndex other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#additionalData">QXmlNodeModelIndex::<wbr/>additionalData()const</a></code></p>
     */
    @QtUninvokable
    public final long additionalData(){
        return additionalData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long additionalData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#data">QXmlNodeModelIndex::<wbr/>data()const</a></code></p>
     */
    @QtUninvokable
    public final long data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#isNull">QXmlNodeModelIndex::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#model">QXmlNodeModelIndex::<wbr/>model()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractXmlNodeModel model(){
        return model_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractXmlNodeModel model_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QXmlNodeModelIndex::<wbr/>operator=(QXmlNodeModelIndex)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex arg__1){
        assign_native_cref_QXmlNodeModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QXmlNodeModelIndex(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#operator-eq-eq">QXmlNodeModelIndex::<wbr/>operator==(QXmlNodeModelIndex)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex other){
        return equals_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QXmlNodeModelIndex(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#operator-eq-eq">QXmlNodeModelIndex::<wbr/>operator==(QXmlNodeModelIndex)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xmlpatterns.QXmlNodeModelIndex) {
            return equals((io.qt.xmlpatterns.QXmlNodeModelIndex) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QXmlNodeModelIndex)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#QXmlNodeModelIndex-1">QXmlNodeModelIndex::<wbr/>QXmlNodeModelIndex(QXmlNodeModelIndex)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QXmlNodeModelIndex clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QXmlNodeModelIndex clone_native(long __this_nativeId);
}
