package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Callback interface for resolving Uniform Resource Identifiers. A Uniform Resource Identifier (URI) is a string that uniquely identifies a resource. URIs are versatile global identifiers. It is often useful to transform a URI that identifies something logical into a URI that locates something physical (a URL), or to simply map a URI to a different URI. QAbstractUriResolver::resolve() provides this functionality</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qabstracturiresolver.html">QAbstractUriResolver</a></code></p>
 */
public abstract class QAbstractUriResolver extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractUriResolver.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractUriResolver {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public io.qt.core.@NonNull QUrl resolve(io.qt.core.@NonNull QUrl relative, io.qt.core.@NonNull QUrl baseURI){
            return resolve_native_cref_QUrl_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(relative), QtJambi_LibraryUtilities.internal.checkedNativeId(baseURI));
        }
        @QtUninvokable
        private native io.qt.core.QUrl resolve_native_cref_QUrl_cref_QUrl_constfct(long __this__nativeId, long relative, long baseURI);
        
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstracturiresolver.html#QAbstractUriResolver">QAbstractUriResolver::<wbr/>QAbstractUriResolver(QObject*)</a></code></p>
     */
    public QAbstractUriResolver(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractUriResolver instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstracturiresolver.html#resolve">QAbstractUriResolver::<wbr/>resolve(QUrl,<wbr/>QUrl)const</a></code></p>
     */
    @QtUninvokable
    public abstract io.qt.core.@NonNull QUrl resolve(io.qt.core.@NonNull QUrl relative, io.qt.core.@NonNull QUrl baseURI);
    
    @QtUninvokable
    private native io.qt.core.QUrl resolve_native_cref_QUrl_cref_QUrl_constfct(long __this__nativeId, long relative, long baseURI);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractUriResolver(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAbstractUriResolver(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractUriResolver instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractUriResolver(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractUriResolver() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #resolve(io.qt.core.QUrl, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl resolve(java.lang.@NonNull String relative, io.qt.core.@NonNull QUrl baseURI) {
        return resolve(new io.qt.core.QUrl(relative), baseURI);
    }
    
    /**
     * <p>Overloaded function for {@link #resolve(io.qt.core.QUrl, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl resolve(io.qt.core.@NonNull QUrl relative, java.lang.@NonNull String baseURI) {
        return resolve(relative, new io.qt.core.QUrl(baseURI));
    }
    
    /**
     * <p>Overloaded function for {@link #resolve(io.qt.core.QUrl, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl resolve(java.lang.@NonNull String relative, java.lang.@NonNull String baseURI) {
        return resolve(new io.qt.core.QUrl(relative), new io.qt.core.QUrl(baseURI));
    }
}
