package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Performs XQueries on XML data, or on non-XML data modeled to look like XML</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qxmlquery.html">QXmlQuery</a></code></p>
 */
public class QXmlQuery extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcFocusDevice = null;
    @QtPropertyMember(enabled=false)
    private Object __rcMessageHandler = null;
    @QtPropertyMember(enabled=false)
    private Object __rcNetworkAccessManager = null;
    @QtPropertyMember(enabled=false)
    private Object __rcUriResolver = null;
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QueryLanguage-enum">QXmlQuery::QueryLanguage</a></code></p>
     */
    public enum QueryLanguage implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QueryLanguage-enum">QXmlQuery::<wbr/>XQuery10</a></code></p>
         */
        XQuery10(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QueryLanguage-enum">QXmlQuery::<wbr/>XSLT20</a></code></p>
         */
        XSLT20(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QueryLanguage-enum">QXmlQuery::<wbr/>XmlSchema11IdentityConstraintSelector</a></code></p>
         */
        XmlSchema11IdentityConstraintSelector(1024),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QueryLanguage-enum">QXmlQuery::<wbr/>XmlSchema11IdentityConstraintField</a></code></p>
         */
        XmlSchema11IdentityConstraintField(2048),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QueryLanguage-enum">QXmlQuery::<wbr/>XPath20</a></code></p>
         */
        XPath20(4096);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private QueryLanguage(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull QueryLanguage resolve(int value) {
            switch (value) {
            case 1: return XQuery10;
            case 2: return XSLT20;
            case 1024: return XmlSchema11IdentityConstraintSelector;
            case 2048: return XmlSchema11IdentityConstraintField;
            case 4096: return XPath20;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery">QXmlQuery::<wbr/>QXmlQuery()</a></code></p>
     */
    public QXmlQuery(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlQuery instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-2">QXmlQuery::<wbr/>QXmlQuery(QXmlNamePool)</a></code></p>
     */
    public QXmlQuery(io.qt.xmlpatterns.@NonNull QXmlNamePool np){
        super((QPrivateConstructor)null);
        initialize_native(this, np);
    }
    
    private native static void initialize_native(QXmlQuery instance, io.qt.xmlpatterns.QXmlNamePool np);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-1">QXmlQuery::<wbr/>QXmlQuery(QXmlQuery)</a></code></p>
     */
    public QXmlQuery(io.qt.xmlpatterns.@StrictNonNull QXmlQuery other){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QXmlQuery instance, io.qt.xmlpatterns.QXmlQuery other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-3">QXmlQuery::<wbr/>QXmlQuery(QXmlQuery::QueryLanguage,<wbr/>QXmlNamePool)</a></code></p>
     */
    public QXmlQuery(io.qt.xmlpatterns.QXmlQuery.@NonNull QueryLanguage queryLanguage, io.qt.xmlpatterns.@NonNull QXmlNamePool np){
        super((QPrivateConstructor)null);
        initialize_native(this, queryLanguage, np);
    }
    
    private native static void initialize_native(QXmlQuery instance, io.qt.xmlpatterns.QXmlQuery.QueryLanguage queryLanguage, io.qt.xmlpatterns.QXmlNamePool np);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-3">QXmlQuery::<wbr/>bindVariable(QString,<wbr/>QIODevice*)</a></code></p>
     */
    @QtUninvokable
    public final void bindVariable(java.lang.@NonNull String localName, io.qt.core.@Nullable QIODevice arg__2){
        bindVariable_native_cref_QString_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), localName, QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @QtUninvokable
    private native void bindVariable_native_cref_QString_QIODevice_ptr(long __this__nativeId, java.lang.String localName, long arg__2);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-1">QXmlQuery::<wbr/>bindVariable(QString,<wbr/>QXmlItem)</a></code></p>
     */
    @QtUninvokable
    public final void bindVariable(java.lang.@NonNull String localName, io.qt.xmlpatterns.@NonNull QXmlItem value){
        bindVariable_native_cref_QString_cref_QXmlItem(QtJambi_LibraryUtilities.internal.nativeId(this), localName, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void bindVariable_native_cref_QString_cref_QXmlItem(long __this__nativeId, java.lang.String localName, long value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-5">QXmlQuery::<wbr/>bindVariable(QString,<wbr/>QXmlQuery)</a></code></p>
     */
    @QtUninvokable
    public final void bindVariable(java.lang.@NonNull String localName, io.qt.xmlpatterns.@StrictNonNull QXmlQuery query){
        java.util.Objects.requireNonNull(query, "Argument 'query': null not expected.");
        bindVariable_native_cref_QString_cref_QXmlQuery(QtJambi_LibraryUtilities.internal.nativeId(this), localName, QtJambi_LibraryUtilities.internal.checkedNativeId(query));
    }
    
    @QtUninvokable
    private native void bindVariable_native_cref_QString_cref_QXmlQuery(long __this__nativeId, java.lang.String localName, long query);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-2">QXmlQuery::<wbr/>bindVariable(QXmlName,<wbr/>QIODevice*)</a></code></p>
     */
    @QtUninvokable
    public final void bindVariable(io.qt.xmlpatterns.@NonNull QXmlName name, io.qt.core.@Nullable QIODevice arg__2){
        bindVariable_native_cref_QXmlName_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @QtUninvokable
    private native void bindVariable_native_cref_QXmlName_QIODevice_ptr(long __this__nativeId, long name, long arg__2);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable">QXmlQuery::<wbr/>bindVariable(QXmlName,<wbr/>QXmlItem)</a></code></p>
     */
    @QtUninvokable
    public final void bindVariable(io.qt.xmlpatterns.@NonNull QXmlName name, io.qt.xmlpatterns.@NonNull QXmlItem value){
        bindVariable_native_cref_QXmlName_cref_QXmlItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void bindVariable_native_cref_QXmlName_cref_QXmlItem(long __this__nativeId, long name, long value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#bindVariable-4">QXmlQuery::<wbr/>bindVariable(QXmlName,<wbr/>QXmlQuery)</a></code></p>
     */
    @QtUninvokable
    public final void bindVariable(io.qt.xmlpatterns.@NonNull QXmlName name, io.qt.xmlpatterns.@StrictNonNull QXmlQuery query){
        java.util.Objects.requireNonNull(query, "Argument 'query': null not expected.");
        bindVariable_native_cref_QXmlName_cref_QXmlQuery(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(query));
    }
    
    @QtUninvokable
    private native void bindVariable_native_cref_QXmlName_cref_QXmlQuery(long __this__nativeId, long name, long query);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-1">QXmlQuery::<wbr/>evaluateTo(QAbstractXmlReceiver*)const</a></code></p>
     */
    @QtUninvokable
    public final boolean evaluateTo(io.qt.xmlpatterns.@StrictNonNull QAbstractXmlReceiver callback){
        java.util.Objects.requireNonNull(callback, "Argument 'callback': null not expected.");
        return evaluateTo_native_QAbstractXmlReceiver_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(callback));
    }
    
    @QtUninvokable
    private native boolean evaluateTo_native_QAbstractXmlReceiver_ptr_constfct(long __this__nativeId, long callback);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-3">QXmlQuery::<wbr/>evaluateTo(QIODevice*)const</a></code></p>
     */
    @QtUninvokable
    public final boolean evaluateTo(io.qt.core.@StrictNonNull QIODevice target){
        java.util.Objects.requireNonNull(target, "Argument 'target': null not expected.");
        return evaluateTo_native_QIODevice_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target));
    }
    
    @QtUninvokable
    private native boolean evaluateTo_native_QIODevice_ptr_constfct(long __this__nativeId, long target);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-4">QXmlQuery::<wbr/>evaluateTo(QString*)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.String evaluateToString(){
        return evaluateToString_native_QString_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String evaluateToString_native_QString_ptr_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo-2">QXmlQuery::<wbr/>evaluateTo(QStringList*)const</a></code></p>
     */
    @QtUninvokable
    public final boolean evaluateTo(java.util.@StrictNonNull @Nullable Collection<java.lang.@NonNull String> target){
        java.util.Objects.requireNonNull(target, "Argument 'target': null not expected.");
        return evaluateTo_native_QStringList_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native boolean evaluateTo_native_QStringList_ptr_constfct(long __this__nativeId, java.util.Collection<java.lang.@NonNull String> target);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#evaluateTo">QXmlQuery::<wbr/>evaluateTo(QXmlResultItems*)const</a></code></p>
     */
    @QtUninvokable
    public final void evaluateTo(io.qt.xmlpatterns.@StrictNonNull QXmlResultItems result){
        java.util.Objects.requireNonNull(result, "Argument 'result': null not expected.");
        evaluateTo_native_QXmlResultItems_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(result));
    }
    
    @QtUninvokable
    private native void evaluateTo_native_QXmlResultItems_ptr_constfct(long __this__nativeId, long result);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#initialTemplateName">QXmlQuery::<wbr/>initialTemplateName()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@NonNull QXmlName initialTemplateName(){
        return initialTemplateName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlName initialTemplateName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#isValid">QXmlQuery::<wbr/>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#messageHandler">QXmlQuery::<wbr/>messageHandler()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractMessageHandler messageHandler(){
        return messageHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractMessageHandler messageHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#namePool">QXmlQuery::<wbr/>namePool()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@NonNull QXmlNamePool namePool(){
        return namePool_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNamePool namePool_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#networkAccessManager">QXmlQuery::<wbr/>networkAccessManager()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@Nullable QNetworkAccessManager networkAccessManager(){
        return networkAccessManager_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkAccessManager networkAccessManager_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#operator-eq">QXmlQuery::<wbr/>operator=(QXmlQuery)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xmlpatterns.@StrictNonNull QXmlQuery other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        assign_native_cref_QXmlQuery(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QXmlQuery(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#queryLanguage">QXmlQuery::<wbr/>queryLanguage()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.QXmlQuery.@NonNull QueryLanguage queryLanguage(){
        return io.qt.xmlpatterns.QXmlQuery.QueryLanguage.resolve(queryLanguage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int queryLanguage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setFocus-2">QXmlQuery::<wbr/>setFocus(QIODevice*)</a></code></p>
     */
    @QtUninvokable
    public final boolean setFocus(io.qt.core.@Nullable QIODevice document){
        boolean __qt_return_value = setFocus_native_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(document));
        __rcFocusDevice = document;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native boolean setFocus_native_QIODevice_ptr(long __this__nativeId, long document);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setFocus-3">QXmlQuery::<wbr/>setFocus(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean setFocus(java.lang.@NonNull String focus){
        return setFocus_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), focus);
    }
    
    @QtUninvokable
    private native boolean setFocus_native_cref_QString(long __this__nativeId, java.lang.String focus);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setFocus-1">QXmlQuery::<wbr/>setFocus(QUrl)</a></code></p>
     */
    @QtUninvokable
    public final boolean setFocus(io.qt.core.@NonNull QUrl documentURI){
        return setFocus_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(documentURI));
    }
    
    @QtUninvokable
    private native boolean setFocus_native_cref_QUrl(long __this__nativeId, long documentURI);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setFocus">QXmlQuery::<wbr/>setFocus(QXmlItem)</a></code></p>
     */
    @QtUninvokable
    public final void setFocus(io.qt.xmlpatterns.@NonNull QXmlItem item){
        setFocus_native_cref_QXmlItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void setFocus_native_cref_QXmlItem(long __this__nativeId, long item);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setInitialTemplateName-1">QXmlQuery::<wbr/>setInitialTemplateName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setInitialTemplateName(java.lang.@NonNull String name){
        setInitialTemplateName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setInitialTemplateName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setInitialTemplateName">QXmlQuery::<wbr/>setInitialTemplateName(QXmlName)</a></code></p>
     */
    @QtUninvokable
    public final void setInitialTemplateName(io.qt.xmlpatterns.@NonNull QXmlName name){
        setInitialTemplateName_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @QtUninvokable
    private native void setInitialTemplateName_native_cref_QXmlName(long __this__nativeId, long name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setMessageHandler">QXmlQuery::<wbr/>setMessageHandler(QAbstractMessageHandler*)</a></code></p>
     */
    @QtUninvokable
    public final void setMessageHandler(io.qt.xmlpatterns.@Nullable QAbstractMessageHandler messageHandler){
        setMessageHandler_native_QAbstractMessageHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(messageHandler));
        __rcMessageHandler = messageHandler;
    }
    
    @QtUninvokable
    private native void setMessageHandler_native_QAbstractMessageHandler_ptr(long __this__nativeId, long messageHandler);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setNetworkAccessManager">QXmlQuery::<wbr/>setNetworkAccessManager(QNetworkAccessManager*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setNetworkAccessManager(io.qt.network.@Nullable QNetworkAccessManager newManager){
        setNetworkAccessManager_native_QNetworkAccessManager_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newManager));
        __rcNetworkAccessManager = newManager;
    }
    
    @QtUninvokable
    private native void setNetworkAccessManager_native_QNetworkAccessManager_ptr(long __this__nativeId, long newManager);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setQuery">QXmlQuery::<wbr/>setQuery(QIODevice*,<wbr/>QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void setQuery(io.qt.core.@Nullable QIODevice sourceCode, io.qt.core.@NonNull QUrl documentURI){
        setQuery_native_QIODevice_ptr_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceCode), QtJambi_LibraryUtilities.internal.checkedNativeId(documentURI));
    }
    
    @QtUninvokable
    private native void setQuery_native_QIODevice_ptr_cref_QUrl(long __this__nativeId, long sourceCode, long documentURI);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setQuery-1">QXmlQuery::<wbr/>setQuery(QString,<wbr/>QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void setQuery(java.lang.@NonNull String sourceCode, io.qt.core.@NonNull QUrl documentURI){
        setQuery_native_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), sourceCode, QtJambi_LibraryUtilities.internal.checkedNativeId(documentURI));
    }
    
    @QtUninvokable
    private native void setQuery_native_cref_QString_cref_QUrl(long __this__nativeId, java.lang.String sourceCode, long documentURI);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setQuery-2">QXmlQuery::<wbr/>setQuery(QUrl,<wbr/>QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void setQuery(io.qt.core.@NonNull QUrl queryURI, io.qt.core.@NonNull QUrl baseURI){
        setQuery_native_cref_QUrl_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(queryURI), QtJambi_LibraryUtilities.internal.checkedNativeId(baseURI));
    }
    
    @QtUninvokable
    private native void setQuery_native_cref_QUrl_cref_QUrl(long __this__nativeId, long queryURI, long baseURI);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#setUriResolver">QXmlQuery::<wbr/>setUriResolver(const QAbstractUriResolver*)</a></code></p>
     */
    @QtUninvokable
    public final void setUriResolver(io.qt.xmlpatterns.@Nullable QAbstractUriResolver resolver){
        setUriResolver_native_const_QAbstractUriResolver_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(resolver));
        __rcUriResolver = resolver;
    }
    
    @QtUninvokable
    private native void setUriResolver_native_const_QAbstractUriResolver_ptr(long __this__nativeId, long resolver);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#uriResolver">QXmlQuery::<wbr/>uriResolver()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractUriResolver uriResolver(){
        return uriResolver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractUriResolver uriResolver_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QXmlQuery(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="http://doc.qt.io/qt-5/qxmlquery.html#QXmlQuery-1">QXmlQuery::<wbr/>QXmlQuery(QXmlQuery)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QXmlQuery clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QXmlQuery clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QXmlQuery(io.qt.xmlpatterns.QXmlQuery.QueryLanguage, io.qt.xmlpatterns.QXmlNamePool)}
     *  with <code>np = new io.qt.xmlpatterns.QXmlNamePool()</code>.</p>
     */
    public QXmlQuery(io.qt.xmlpatterns.QXmlQuery.@NonNull QueryLanguage queryLanguage) {
        this(queryLanguage, new io.qt.xmlpatterns.QXmlNamePool());
    }
    
    /**
     * <p>Overloaded function for {@link #bindVariable(java.lang.String, io.qt.xmlpatterns.QXmlQuery)}.</p>
     */
    @QtUninvokable
    public final void bindVariable(java.lang.@NonNull String localName, io.qt.xmlpatterns.@NonNull QXmlNamePool query) {
        bindVariable(localName, new io.qt.xmlpatterns.QXmlQuery(query));
    }
    
    /**
     * <p>Overloaded function for {@link #bindVariable(java.lang.String, io.qt.xmlpatterns.QXmlQuery)}.</p>
     */
    @QtUninvokable
    public final void bindVariable(java.lang.@NonNull String localName, io.qt.xmlpatterns.QXmlQuery.@NonNull QueryLanguage query) {
        bindVariable(localName, new io.qt.xmlpatterns.QXmlQuery(query));
    }
    
    /**
     * <p>Overloaded function for {@link #bindVariable(io.qt.xmlpatterns.QXmlName, io.qt.xmlpatterns.QXmlQuery)}.</p>
     */
    @QtUninvokable
    public final void bindVariable(io.qt.xmlpatterns.@NonNull QXmlName name, io.qt.xmlpatterns.@NonNull QXmlNamePool query) {
        bindVariable(name, new io.qt.xmlpatterns.QXmlQuery(query));
    }
    
    /**
     * <p>Overloaded function for {@link #bindVariable(io.qt.xmlpatterns.QXmlName, io.qt.xmlpatterns.QXmlQuery)}.</p>
     */
    @QtUninvokable
    public final void bindVariable(io.qt.xmlpatterns.@NonNull QXmlName name, io.qt.xmlpatterns.QXmlQuery.@NonNull QueryLanguage query) {
        bindVariable(name, new io.qt.xmlpatterns.QXmlQuery(query));
    }
    
    /**
     * @deprecated Use {@link #assign(io.qt.xmlpatterns.QXmlQuery)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.xmlpatterns.@StrictNonNull QXmlQuery other) {
        assign(other);
    }
    
    /**
     * @deprecated Use {@link #assign(io.qt.xmlpatterns.QXmlNamePool)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.xmlpatterns.@NonNull QXmlNamePool other) {
        assign(new io.qt.xmlpatterns.QXmlQuery(other));
    }
    
    /**
     * @deprecated Use {@link #assign(io.qt.xmlpatterns.QXmlQuery.QueryLanguage)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.xmlpatterns.QXmlQuery.@NonNull QueryLanguage other) {
        assign(new io.qt.xmlpatterns.QXmlQuery(other));
    }
    
    /**
     * <p>Overloaded function for {@link #assign(io.qt.xmlpatterns.QXmlQuery)}.</p>
     */
    @QtUninvokable
    public final void assign(io.qt.xmlpatterns.@NonNull QXmlNamePool other) {
        assign(new io.qt.xmlpatterns.QXmlQuery(other));
    }
    
    /**
     * <p>Overloaded function for {@link #assign(io.qt.xmlpatterns.QXmlQuery)}.</p>
     */
    @QtUninvokable
    public final void assign(io.qt.xmlpatterns.QXmlQuery.@NonNull QueryLanguage other) {
        assign(new io.qt.xmlpatterns.QXmlQuery(other));
    }
    
    /**
     * <p>Overloaded function for {@link #setQuery(io.qt.core.QIODevice, io.qt.core.QUrl)}
     *  with <code>documentURI = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setQuery(io.qt.core.@Nullable QIODevice sourceCode) {
        setQuery(sourceCode, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setQuery(io.qt.core.QIODevice, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setQuery(io.qt.core.@Nullable QIODevice sourceCode, java.lang.@NonNull String documentURI) {
        setQuery(sourceCode, new io.qt.core.QUrl(documentURI));
    }
    
    /**
     * <p>Overloaded function for {@link #setQuery(java.lang.String, io.qt.core.QUrl)}
     *  with <code>documentURI = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setQuery(java.lang.@NonNull String sourceCode) {
        setQuery(sourceCode, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setQuery(io.qt.core.QUrl, io.qt.core.QUrl)}
     *  with <code>baseURI = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setQuery(io.qt.core.@NonNull QUrl queryURI) {
        setQuery(queryURI, new io.qt.core.QUrl());
    }
}
