package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Contains either an XML node or an atomic value</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qxmlitem.html">QXmlItem</a></code></p>
 */
public class QXmlItem extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#QXmlItem">QXmlItem::<wbr/>QXmlItem()</a></code></p>
     */
    public QXmlItem(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlItem instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#QXmlItem-3">QXmlItem::<wbr/>QXmlItem(QVariant)</a></code></p>
     */
    public QXmlItem(java.lang.Object atomicValue){
        super((QPrivateConstructor)null);
        initialize_native(this, atomicValue);
    }
    
    private native static void initialize_native(QXmlItem instance, java.lang.Object atomicValue);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#QXmlItem-1">QXmlItem::<wbr/>QXmlItem(QXmlItem)</a></code></p>
     */
    public QXmlItem(io.qt.xmlpatterns.@NonNull QXmlItem other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QXmlItem instance, io.qt.xmlpatterns.QXmlItem other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#QXmlItem-2">QXmlItem::<wbr/>QXmlItem(QXmlNodeModelIndex)</a></code></p>
     */
    public QXmlItem(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex node){
        super((QPrivateConstructor)null);
        initialize_native(this, node);
    }
    
    private native static void initialize_native(QXmlItem instance, io.qt.xmlpatterns.QXmlNodeModelIndex node);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#isAtomicValue">QXmlItem::<wbr/>isAtomicValue()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isAtomicValue(){
        return isAtomicValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAtomicValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#isNode">QXmlItem::<wbr/>isNode()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNode(){
        return isNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#isNull">QXmlItem::<wbr/>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#operator-eq">QXmlItem::<wbr/>operator=(QXmlItem)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xmlpatterns.@NonNull QXmlItem other){
        assign_native_cref_QXmlItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QXmlItem(long __this__nativeId, long other);
    
    /**
     * <p>See <code>operator==(QXmlItem,<wbr/>QXmlItem)</code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.xmlpatterns.@NonNull QXmlItem arg2){
        return equals_native_cref_QXmlItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg2));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QXmlItem(long __this__nativeId, long arg2);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#toAtomicValue">QXmlItem::<wbr/>toAtomicValue()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object toAtomicValue(){
        return toAtomicValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object toAtomicValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#toNodeModelIndex">QXmlItem::<wbr/>toNodeModelIndex()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex toNodeModelIndex(){
        return toNodeModelIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNodeModelIndex toNodeModelIndex_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QXmlItem(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code>operator==(QXmlItem,<wbr/>QXmlItem)</code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xmlpatterns.QXmlItem) {
            return equals((io.qt.xmlpatterns.QXmlItem) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QXmlItem)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="http://doc.qt.io/qt-5/qxmlitem.html#QXmlItem-1">QXmlItem::<wbr/>QXmlItem(QXmlItem)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QXmlItem clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QXmlItem clone_native(long __this_nativeId);
}
