package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Implementation of QAbstractXmlReceiver for transforming XQuery output into unformatted XML</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qxmlserializer.html">QXmlSerializer</a></code></p>
 */
public class QXmlSerializer extends io.qt.xmlpatterns.QAbstractXmlReceiver
{
    @QtPropertyMember(enabled=false)
    private Object __rcCodec = null;
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlserializer.html#QXmlSerializer">QXmlSerializer::<wbr/>QXmlSerializer(QXmlQuery,<wbr/>QIODevice*)</a></code></p>
     */
    public QXmlSerializer(io.qt.xmlpatterns.@StrictNonNull QXmlQuery query, io.qt.core.@Nullable QIODevice outputDevice){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(query, "Argument 'query': null not expected.");
        initialize_native(this, query, outputDevice);
    }
    
    private native static void initialize_native(QXmlSerializer instance, io.qt.xmlpatterns.QXmlQuery query, io.qt.core.QIODevice outputDevice);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlserializer.html#codec">QXmlSerializer::<wbr/>codec()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QTextCodec codec(){
        return codec_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QTextCodec codec_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlserializer.html#outputDevice">QXmlSerializer::<wbr/>outputDevice()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QIODevice outputDevice(){
        return outputDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QIODevice outputDevice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlserializer.html#setCodec">QXmlSerializer::<wbr/>setCodec(const QTextCodec*)</a></code></p>
     */
    @QtUninvokable
    public final void setCodec(io.qt.core.@Nullable QTextCodec codec){
        setCodec_native_const_QTextCodec_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(codec));
        __rcCodec = codec;
    }
    
    @QtUninvokable
    private native void setCodec_native_const_QTextCodec_ptr(long __this__nativeId, long codec);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#atomicValue">QAbstractXmlReceiver::<wbr/>atomicValue(QVariant)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void atomicValue(java.lang.Object value){
        atomicValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void atomicValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#attribute">QAbstractXmlReceiver::<wbr/>attribute(QXmlName,<wbr/>QStringRef)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void attribute(io.qt.xmlpatterns.@NonNull QXmlName name, java.lang.@NonNull String value){
        attribute_native_cref_QXmlName_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), value);
    }
    
    @QtUninvokable
    private native void attribute_native_cref_QXmlName_cref_QStringRef(long __this__nativeId, long name, java.lang.String value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#characters">QAbstractXmlReceiver::<wbr/>characters(QStringRef)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void characters(java.lang.@NonNull String value){
        characters_native_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void characters_native_cref_QStringRef(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#comment">QAbstractXmlReceiver::<wbr/>comment(QString)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void comment(java.lang.@NonNull String value){
        comment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void comment_native_cref_QString(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endDocument">QAbstractXmlReceiver::<wbr/>endDocument()</a></code></p>
     */
    @QtUninvokable
    @Override
    public void endDocument(){
        endDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endDocument_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endElement">QAbstractXmlReceiver::<wbr/>endElement()</a></code></p>
     */
    @QtUninvokable
    @Override
    public void endElement(){
        endElement_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endElement_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endOfSequence">QAbstractXmlReceiver::<wbr/>endOfSequence()</a></code></p>
     */
    @QtUninvokable
    @Override
    public void endOfSequence(){
        endOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endOfSequence_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#namespaceBinding">QAbstractXmlReceiver::<wbr/>namespaceBinding(QXmlName)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void namespaceBinding(io.qt.xmlpatterns.@NonNull QXmlName nb){
        namespaceBinding_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(nb));
    }
    
    @QtUninvokable
    private native void namespaceBinding_native_cref_QXmlName(long __this__nativeId, long nb);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#processingInstruction">QAbstractXmlReceiver::<wbr/>processingInstruction(QXmlName,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void processingInstruction(io.qt.xmlpatterns.@NonNull QXmlName name, java.lang.@NonNull String value){
        processingInstruction_native_cref_QXmlName_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), value);
    }
    
    @QtUninvokable
    private native void processingInstruction_native_cref_QXmlName_cref_QString(long __this__nativeId, long name, java.lang.String value);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startDocument">QAbstractXmlReceiver::<wbr/>startDocument()</a></code></p>
     */
    @QtUninvokable
    @Override
    public void startDocument(){
        startDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void startDocument_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startElement">QAbstractXmlReceiver::<wbr/>startElement(QXmlName)</a></code></p>
     */
    @QtUninvokable
    @Override
    public void startElement(io.qt.xmlpatterns.@NonNull QXmlName name){
        startElement_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @QtUninvokable
    private native void startElement_native_cref_QXmlName(long __this__nativeId, long name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startOfSequence">QAbstractXmlReceiver::<wbr/>startOfSequence()</a></code></p>
     */
    @QtUninvokable
    @Override
    public void startOfSequence(){
        startOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void startOfSequence_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QXmlSerializer(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QXmlSerializer(io.qt.xmlpatterns.QXmlQuery, io.qt.core.QIODevice)}.</p>
     */
    public QXmlSerializer(io.qt.xmlpatterns.@NonNull QXmlNamePool query, io.qt.core.@Nullable QIODevice outputDevice) {
        this(new io.qt.xmlpatterns.QXmlQuery(query), outputDevice);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QXmlSerializer(io.qt.xmlpatterns.QXmlQuery, io.qt.core.QIODevice)}.</p>
     */
    public QXmlSerializer(io.qt.xmlpatterns.QXmlQuery.@NonNull QueryLanguage query, io.qt.core.@Nullable QIODevice outputDevice) {
        this(new io.qt.xmlpatterns.QXmlQuery(query), outputDevice);
    }
}
