package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Validates XML instance documents against a W3C XML Schema</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html">QXmlSchemaValidator</a></code></p>
 */
public class QXmlSchemaValidator extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#QXmlSchemaValidator">QXmlSchemaValidator::<wbr/>QXmlSchemaValidator()</a></code></p>
     */
    public QXmlSchemaValidator(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlSchemaValidator instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#QXmlSchemaValidator-1">QXmlSchemaValidator::<wbr/>QXmlSchemaValidator(QXmlSchema)</a></code></p>
     */
    public QXmlSchemaValidator(io.qt.xmlpatterns.@NonNull QXmlSchema schema){
        super((QPrivateConstructor)null);
        initialize_native(this, schema);
    }
    
    private native static void initialize_native(QXmlSchemaValidator instance, io.qt.xmlpatterns.QXmlSchema schema);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#messageHandler">QXmlSchemaValidator::<wbr/>messageHandler()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractMessageHandler messageHandler(){
        return messageHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractMessageHandler messageHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#namePool">QXmlSchemaValidator::<wbr/>namePool()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@NonNull QXmlNamePool namePool(){
        return namePool_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNamePool namePool_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#networkAccessManager">QXmlSchemaValidator::<wbr/>networkAccessManager()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@Nullable QNetworkAccessManager networkAccessManager(){
        return networkAccessManager_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkAccessManager networkAccessManager_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#schema">QXmlSchemaValidator::<wbr/>schema()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@NonNull QXmlSchema schema(){
        return schema_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlSchema schema_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#setMessageHandler">QXmlSchemaValidator::<wbr/>setMessageHandler(QAbstractMessageHandler*)</a></code></p>
     */
    @QtUninvokable
    public final void setMessageHandler(io.qt.xmlpatterns.@Nullable QAbstractMessageHandler handler){
        setMessageHandler_native_QAbstractMessageHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(handler));
    }
    
    @QtUninvokable
    private native void setMessageHandler_native_QAbstractMessageHandler_ptr(long __this__nativeId, long handler);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#setNetworkAccessManager">QXmlSchemaValidator::<wbr/>setNetworkAccessManager(QNetworkAccessManager*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setNetworkAccessManager(io.qt.network.@Nullable QNetworkAccessManager networkmanager){
        setNetworkAccessManager_native_QNetworkAccessManager_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(networkmanager));
    }
    
    @QtUninvokable
    private native void setNetworkAccessManager_native_QNetworkAccessManager_ptr(long __this__nativeId, long networkmanager);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#setSchema">QXmlSchemaValidator::<wbr/>setSchema(QXmlSchema)</a></code></p>
     */
    @QtUninvokable
    public final void setSchema(io.qt.xmlpatterns.@NonNull QXmlSchema schema){
        setSchema_native_cref_QXmlSchema(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(schema));
    }
    
    @QtUninvokable
    private native void setSchema_native_cref_QXmlSchema(long __this__nativeId, long schema);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#setUriResolver">QXmlSchemaValidator::<wbr/>setUriResolver(const QAbstractUriResolver*)</a></code></p>
     */
    @QtUninvokable
    public final void setUriResolver(io.qt.xmlpatterns.@Nullable QAbstractUriResolver resolver){
        setUriResolver_native_const_QAbstractUriResolver_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(resolver));
    }
    
    @QtUninvokable
    private native void setUriResolver_native_const_QAbstractUriResolver_ptr(long __this__nativeId, long resolver);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#uriResolver">QXmlSchemaValidator::<wbr/>uriResolver()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractUriResolver uriResolver(){
        return uriResolver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractUriResolver uriResolver_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#validate-2">QXmlSchemaValidator::<wbr/>validate(QByteArray,<wbr/>QUrl)const</a></code></p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@NonNull QByteArray data, io.qt.core.@NonNull QUrl documentUri){
        return validate_native_cref_QByteArray_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), QtJambi_LibraryUtilities.internal.checkedNativeId(documentUri));
    }
    
    @QtUninvokable
    private native boolean validate_native_cref_QByteArray_cref_QUrl_constfct(long __this__nativeId, long data, long documentUri);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#validate-1">QXmlSchemaValidator::<wbr/>validate(QIODevice*,<wbr/>QUrl)const</a></code></p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@Nullable QIODevice source, io.qt.core.@NonNull QUrl documentUri){
        return validate_native_QIODevice_ptr_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source), QtJambi_LibraryUtilities.internal.checkedNativeId(documentUri));
    }
    
    @QtUninvokable
    private native boolean validate_native_QIODevice_ptr_cref_QUrl_constfct(long __this__nativeId, long source, long documentUri);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#validate">QXmlSchemaValidator::<wbr/>validate(QUrl)const</a></code></p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@NonNull QUrl source){
        return validate_native_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native boolean validate_native_cref_QUrl_constfct(long __this__nativeId, long source);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QXmlSchemaValidator(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #validate(io.qt.core.QByteArray, io.qt.core.QUrl)}
     *  with <code>documentUri = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@NonNull QByteArray data) {
        return validate(data, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #validate(byte[], io.qt.core.QUrl)}
     *  with <code>documentUri = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final boolean validate(byte @NonNull[] data) {
        return validate(data, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #validate(io.qt.core.QByteArray, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final boolean validate(byte @NonNull[] data, io.qt.core.@NonNull QUrl documentUri) {
        return validate(new io.qt.core.QByteArray(data), documentUri);
    }
    
    /**
     * <p>Overloaded function for {@link #validate(io.qt.core.QByteArray, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@NonNull QByteArray data, java.lang.@NonNull String documentUri) {
        return validate(data, new io.qt.core.QUrl(documentUri));
    }
    
    /**
     * <p>Overloaded function for {@link #validate(io.qt.core.QByteArray, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final boolean validate(byte @NonNull[] data, java.lang.@NonNull String documentUri) {
        return validate(new io.qt.core.QByteArray(data), new io.qt.core.QUrl(documentUri));
    }
    
    /**
     * <p>Overloaded function for {@link #validate(io.qt.core.QIODevice, io.qt.core.QUrl)}
     *  with <code>documentUri = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@Nullable QIODevice source) {
        return validate(source, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #validate(io.qt.core.QIODevice, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@Nullable QIODevice source, java.lang.@NonNull String documentUri) {
        return validate(source, new io.qt.core.QUrl(documentUri));
    }
    
    /**
     * <p>Overloaded function for {@link #validate(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final boolean validate(java.lang.@NonNull String source) {
        return validate(new io.qt.core.QUrl(source));
    }
}
