package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Identifies a location in a resource by URI, line, and column</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html">QSourceLocation</a></code></p>
 */
public class QSourceLocation extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#QSourceLocation">QSourceLocation::<wbr>QSourceLocation()</a></code></p>
     */
    public QSourceLocation(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QSourceLocation instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#QSourceLocation-1">QSourceLocation::<wbr>QSourceLocation(QSourceLocation)</a></code></p>
     */
    public QSourceLocation(io.qt.xmlpatterns.@NonNull QSourceLocation other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QSourceLocation instance, io.qt.xmlpatterns.QSourceLocation other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#QSourceLocation-2">QSourceLocation::<wbr>QSourceLocation(QUrl,<wbr>int,<wbr>int)</a></code></p>
     */
    public QSourceLocation(io.qt.core.@NonNull QUrl uri, int line, int column){
        super((QPrivateConstructor)null);
        initialize_native(this, uri, line, column);
    }
    
    private native static void initialize_native(QSourceLocation instance, io.qt.core.QUrl uri, int line, int column);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#column">QSourceLocation::<wbr>column()const</a></code></p>
     */
    @QtUninvokable
    public final long column(){
        return column_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long column_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#isNull">QSourceLocation::<wbr>isNull()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#line">QSourceLocation::<wbr>line()const</a></code></p>
     */
    @QtUninvokable
    public final long line(){
        return line_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long line_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#operator-eq">QSourceLocation::<wbr>operator=(QSourceLocation)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xmlpatterns.@NonNull QSourceLocation other){
        assign_native_cref_QSourceLocation(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QSourceLocation(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#operator-eq-eq">QSourceLocation::<wbr>operator==(QSourceLocation)const</a></code></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.xmlpatterns.@NonNull QSourceLocation other){
        return operator_equal_native_cref_QSourceLocation_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QSourceLocation_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#setColumn">QSourceLocation::<wbr>setColumn(qint64)</a></code></p>
     */
    @QtUninvokable
    public final void setColumn(long newColumn){
        setColumn_native_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), newColumn);
    }
    
    @QtUninvokable
    private native void setColumn_native_qint64(long __this__nativeId, long newColumn);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#setLine">QSourceLocation::<wbr>setLine(qint64)</a></code></p>
     */
    @QtUninvokable
    public final void setLine(long newLine){
        setLine_native_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), newLine);
    }
    
    @QtUninvokable
    private native void setLine_native_qint64(long __this__nativeId, long newLine);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#setUri">QSourceLocation::<wbr>setUri(QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void setUri(io.qt.core.@NonNull QUrl newUri){
        setUri_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newUri));
    }
    
    @QtUninvokable
    private native void setUri_native_cref_QUrl(long __this__nativeId, long newUri);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#uri">QSourceLocation::<wbr>uri()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl uri(){
        return uri_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl uri_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSourceLocation(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qsourcelocation.html#operator-eq-eq">QSourceLocation::<wbr>operator==(QSourceLocation)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xmlpatterns.QSourceLocation) {
            return operator_equal((io.qt.xmlpatterns.QSourceLocation) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QSourceLocation)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    /**
     * <p>See <code>operator&lt;&lt;(QDebug,<wbr>QSourceLocation)</code></p>
     */
    @QtUninvokable
    @Override
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QSourceLocation clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QSourceLocation clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QSourceLocation(io.qt.core.QUrl, int, int)}
     *  with <code>column = -1</code>.</p>
     */
    public QSourceLocation(io.qt.core.@NonNull QUrl uri, int line) {
        this(uri, line, (int)-1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSourceLocation(io.qt.core.QUrl, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>line = -1</code></li>
     * <li><code>column = -1</code></li>
     * </ul>
     */
    public QSourceLocation(io.qt.core.@NonNull QUrl uri) {
        this(uri, (int)-1, (int)-1);
    }
}
