package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Validates XML instance documents against a W3C XML Schema</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html">QXmlSchemaValidator</a></p>
 */
public class QXmlSchemaValidator extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#QXmlSchemaValidator">QXmlSchemaValidator::QXmlSchemaValidator()</a></p>
     */
    public QXmlSchemaValidator(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlSchemaValidator instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#QXmlSchemaValidator-1">QXmlSchemaValidator::QXmlSchemaValidator(QXmlSchema)</a></p>
     */
    public QXmlSchemaValidator(io.qt.xmlpatterns.@NonNull QXmlSchema schema){
        super((QPrivateConstructor)null);
        initialize_native(this, schema);
    }
    
    private native static void initialize_native(QXmlSchemaValidator instance, io.qt.xmlpatterns.QXmlSchema schema);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#messageHandler">QXmlSchemaValidator::messageHandler()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractMessageHandler messageHandler(){
        return messageHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractMessageHandler messageHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#namePool">QXmlSchemaValidator::namePool()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@NonNull QXmlNamePool namePool(){
        return namePool_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNamePool namePool_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#networkAccessManager">QXmlSchemaValidator::networkAccessManager()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@Nullable QNetworkAccessManager networkAccessManager(){
        return networkAccessManager_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkAccessManager networkAccessManager_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#schema">QXmlSchemaValidator::schema()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@NonNull QXmlSchema schema(){
        return schema_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlSchema schema_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#setMessageHandler">QXmlSchemaValidator::setMessageHandler(QAbstractMessageHandler*)</a></p>
     */
    @QtUninvokable
    public final void setMessageHandler(io.qt.xmlpatterns.@Nullable QAbstractMessageHandler handler){
        setMessageHandler_native_QAbstractMessageHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(handler));
    }
    
    @QtUninvokable
    private native void setMessageHandler_native_QAbstractMessageHandler_ptr(long __this__nativeId, long handler);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#setNetworkAccessManager">QXmlSchemaValidator::setNetworkAccessManager(QNetworkAccessManager*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setNetworkAccessManager(io.qt.network.@Nullable QNetworkAccessManager networkmanager){
        setNetworkAccessManager_native_QNetworkAccessManager_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(networkmanager));
    }
    
    @QtUninvokable
    private native void setNetworkAccessManager_native_QNetworkAccessManager_ptr(long __this__nativeId, long networkmanager);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#setSchema">QXmlSchemaValidator::setSchema(QXmlSchema)</a></p>
     */
    @QtUninvokable
    public final void setSchema(io.qt.xmlpatterns.@NonNull QXmlSchema schema){
        setSchema_native_cref_QXmlSchema(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(schema));
    }
    
    @QtUninvokable
    private native void setSchema_native_cref_QXmlSchema(long __this__nativeId, long schema);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#setUriResolver">QXmlSchemaValidator::setUriResolver(const QAbstractUriResolver*)</a></p>
     */
    @QtUninvokable
    public final void setUriResolver(io.qt.xmlpatterns.@Nullable QAbstractUriResolver resolver){
        setUriResolver_native_const_QAbstractUriResolver_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(resolver));
    }
    
    @QtUninvokable
    private native void setUriResolver_native_const_QAbstractUriResolver_ptr(long __this__nativeId, long resolver);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#uriResolver">QXmlSchemaValidator::uriResolver()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractUriResolver uriResolver(){
        return uriResolver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractUriResolver uriResolver_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #validate(io.qt.core.QIODevice, io.qt.core.QUrl)}
     *  with <code>documentUri = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@Nullable QIODevice source) {
        return validate(source, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#validate-1">QXmlSchemaValidator::validate(QIODevice*,QUrl)const</a></p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@Nullable QIODevice source, io.qt.core.@NonNull QUrl documentUri){
        return validate_native_QIODevice_ptr_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source), QtJambi_LibraryUtilities.internal.checkedNativeId(documentUri));
    }
    
    @QtUninvokable
    private native boolean validate_native_QIODevice_ptr_cref_QUrl_constfct(long __this__nativeId, long source, long documentUri);
    
    /**
     * <p>Overloaded function for {@link #validate(io.qt.core.QByteArray, io.qt.core.QUrl)}
     *  with <code>documentUri = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@NonNull QByteArray data) {
        return validate(data, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#validate-2">QXmlSchemaValidator::validate(QByteArray,QUrl)const</a></p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@NonNull QByteArray data, io.qt.core.@NonNull QUrl documentUri){
        return validate_native_cref_QByteArray_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), QtJambi_LibraryUtilities.internal.checkedNativeId(documentUri));
    }
    
    @QtUninvokable
    private native boolean validate_native_cref_QByteArray_cref_QUrl_constfct(long __this__nativeId, long data, long documentUri);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschemavalidator.html#validate">QXmlSchemaValidator::validate(QUrl)const</a></p>
     */
    @QtUninvokable
    public final boolean validate(io.qt.core.@NonNull QUrl source){
        return validate_native_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native boolean validate_native_cref_QUrl_constfct(long __this__nativeId, long source);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QXmlSchemaValidator(QPrivateConstructor p) { super(p); } 
    
}
