package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Loading and validation of a W3C XML Schema</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qxmlschema.html">QXmlSchema</a></p>
 */
public class QXmlSchema extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#QXmlSchema">QXmlSchema::QXmlSchema()</a></p>
     */
    public QXmlSchema(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlSchema instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#QXmlSchema-1">QXmlSchema::QXmlSchema(QXmlSchema)</a></p>
     */
    public QXmlSchema(io.qt.xmlpatterns.@NonNull QXmlSchema other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QXmlSchema instance, io.qt.xmlpatterns.QXmlSchema other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#documentUri">QXmlSchema::documentUri()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl documentUri(){
        return documentUri_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl documentUri_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#isValid">QXmlSchema::isValid()const</a></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #load(io.qt.core.QIODevice, io.qt.core.QUrl)}
     *  with <code>documentUri = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final boolean load(io.qt.core.@Nullable QIODevice source) {
        return load(source, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#load-1">QXmlSchema::load(QIODevice*,QUrl)</a></p>
     */
    @QtUninvokable
    public final boolean load(io.qt.core.@Nullable QIODevice source, io.qt.core.@NonNull QUrl documentUri){
        return load_native_QIODevice_ptr_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source), QtJambi_LibraryUtilities.internal.checkedNativeId(documentUri));
    }
    
    @QtUninvokable
    private native boolean load_native_QIODevice_ptr_cref_QUrl(long __this__nativeId, long source, long documentUri);
    
    /**
     * <p>Overloaded function for {@link #load(io.qt.core.QByteArray, io.qt.core.QUrl)}
     *  with <code>documentUri = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final boolean load(io.qt.core.@NonNull QByteArray data) {
        return load(data, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#load-2">QXmlSchema::load(QByteArray,QUrl)</a></p>
     */
    @QtUninvokable
    public final boolean load(io.qt.core.@NonNull QByteArray data, io.qt.core.@NonNull QUrl documentUri){
        return load_native_cref_QByteArray_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), QtJambi_LibraryUtilities.internal.checkedNativeId(documentUri));
    }
    
    @QtUninvokable
    private native boolean load_native_cref_QByteArray_cref_QUrl(long __this__nativeId, long data, long documentUri);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#load">QXmlSchema::load(QUrl)</a></p>
     */
    @QtUninvokable
    public final boolean load(io.qt.core.@NonNull QUrl source){
        return load_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native boolean load_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#messageHandler">QXmlSchema::messageHandler()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractMessageHandler messageHandler(){
        return messageHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractMessageHandler messageHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#namePool">QXmlSchema::namePool()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@NonNull QXmlNamePool namePool(){
        return namePool_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNamePool namePool_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#networkAccessManager">QXmlSchema::networkAccessManager()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@Nullable QNetworkAccessManager networkAccessManager(){
        return networkAccessManager_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkAccessManager networkAccessManager_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#operator-eq">QXmlSchema::operator=(QXmlSchema)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xmlpatterns.@NonNull QXmlSchema other){
        assign_native_cref_QXmlSchema(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QXmlSchema(long __this__nativeId, long other);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.xmlpatterns.@NonNull QXmlSchema arg2){
        return operator_equal_native_cref_QXmlSchema(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg2));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QXmlSchema(long __this__nativeId, long arg2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#setMessageHandler">QXmlSchema::setMessageHandler(QAbstractMessageHandler*)</a></p>
     */
    @QtUninvokable
    public final void setMessageHandler(io.qt.xmlpatterns.@Nullable QAbstractMessageHandler handler){
        setMessageHandler_native_QAbstractMessageHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(handler));
    }
    
    @QtUninvokable
    private native void setMessageHandler_native_QAbstractMessageHandler_ptr(long __this__nativeId, long handler);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#setNetworkAccessManager">QXmlSchema::setNetworkAccessManager(QNetworkAccessManager*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setNetworkAccessManager(io.qt.network.@Nullable QNetworkAccessManager networkmanager){
        setNetworkAccessManager_native_QNetworkAccessManager_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(networkmanager));
    }
    
    @QtUninvokable
    private native void setNetworkAccessManager_native_QNetworkAccessManager_ptr(long __this__nativeId, long networkmanager);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#setUriResolver">QXmlSchema::setUriResolver(const QAbstractUriResolver*)</a></p>
     */
    @QtUninvokable
    public final void setUriResolver(io.qt.xmlpatterns.@Nullable QAbstractUriResolver resolver){
        setUriResolver_native_const_QAbstractUriResolver_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(resolver));
    }
    
    @QtUninvokable
    private native void setUriResolver_native_const_QAbstractUriResolver_ptr(long __this__nativeId, long resolver);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#uriResolver">QXmlSchema::uriResolver()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractUriResolver uriResolver(){
        return uriResolver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractUriResolver uriResolver_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QXmlSchema(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xmlpatterns.QXmlSchema) {
            return operator_equal((io.qt.xmlpatterns.QXmlSchema) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QXmlSchema clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QXmlSchema clone_native(long __this_nativeId);
}
