package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Represents the name of an XML node, in an efficient, namespace-aware way. QXmlName represents the name of an XML node in a way that is both efficient and safe for comparing names. Normally, an XML node represents an XML element or attribute, but QXmlName can also represent the names of other kinds of nodes, e.g., QAbstractXmlReceiver::processingInstruction() and QAbstractXmlReceiver::namespaceBinding()</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qxmlname.html">QXmlName</a></p>
 */
public class QXmlName extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#QXmlName">QXmlName::QXmlName()</a></p>
     */
    public QXmlName(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlName instance);
    
    /**
     * <p>Overloaded constructor for {@link #QXmlName(io.qt.xmlpatterns.QXmlNamePool, java.lang.String, java.lang.String, java.lang.String)}
     *  with <code>prefix = (String)null</code>.</p>
     */
    public QXmlName(io.qt.xmlpatterns.@StrictNonNull QXmlNamePool namePool, java.lang.@NonNull String localName, java.lang.@NonNull String namespaceURI) {
        this(namePool, localName, namespaceURI, (String)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QXmlName(io.qt.xmlpatterns.QXmlNamePool, java.lang.String, java.lang.String, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>namespaceURI = (String)null</code></li>
     * <li><code>prefix = (String)null</code></li>
     * </ul>
     */
    public QXmlName(io.qt.xmlpatterns.@StrictNonNull QXmlNamePool namePool, java.lang.@NonNull String localName) {
        this(namePool, localName, (String)null, (String)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#QXmlName-1">QXmlName::QXmlName(QXmlNamePool&amp;,QString,QString,QString)</a></p>
     */
    public QXmlName(io.qt.xmlpatterns.@StrictNonNull QXmlNamePool namePool, java.lang.@NonNull String localName, java.lang.@NonNull String namespaceURI, java.lang.@NonNull String prefix){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(namePool, "Argument 'namePool': null not expected.");
        initialize_native(this, namePool, localName, namespaceURI, prefix);
    }
    
    private native static void initialize_native(QXmlName instance, io.qt.xmlpatterns.QXmlNamePool namePool, java.lang.String localName, java.lang.String namespaceURI, java.lang.String prefix);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#QXmlName-2">QXmlName::QXmlName(QXmlName)</a></p>
     */
    public QXmlName(io.qt.xmlpatterns.@NonNull QXmlName other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QXmlName instance, io.qt.xmlpatterns.QXmlName other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#isNull">QXmlName::isNull()const</a></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#localName">QXmlName::localName(QXmlNamePool)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String localName(io.qt.xmlpatterns.@NonNull QXmlNamePool query){
        return localName_native_cref_QXmlNamePool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(query));
    }
    
    @QtUninvokable
    private native java.lang.String localName_native_cref_QXmlNamePool_constfct(long __this__nativeId, long query);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#namespaceUri">QXmlName::namespaceUri(QXmlNamePool)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String namespaceUri(io.qt.xmlpatterns.@NonNull QXmlNamePool query){
        return namespaceUri_native_cref_QXmlNamePool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(query));
    }
    
    @QtUninvokable
    private native java.lang.String namespaceUri_native_cref_QXmlNamePool_constfct(long __this__nativeId, long query);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#operator-eq">QXmlName::operator=(QXmlName)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xmlpatterns.@NonNull QXmlName other){
        assign_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QXmlName(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#operator-eq-eq">QXmlName::operator==(QXmlName)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.xmlpatterns.@NonNull QXmlName other){
        return operator_equal_native_cref_QXmlName_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QXmlName_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#prefix">QXmlName::prefix(QXmlNamePool)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String prefix(io.qt.xmlpatterns.@NonNull QXmlNamePool query){
        return prefix_native_cref_QXmlNamePool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(query));
    }
    
    @QtUninvokable
    private native java.lang.String prefix_native_cref_QXmlNamePool_constfct(long __this__nativeId, long query);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#toClarkName">QXmlName::toClarkName(QXmlNamePool)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toClarkName(io.qt.xmlpatterns.@NonNull QXmlNamePool query){
        return toClarkName_native_cref_QXmlNamePool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(query));
    }
    
    @QtUninvokable
    private native java.lang.String toClarkName_native_cref_QXmlNamePool_constfct(long __this__nativeId, long query);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#fromClarkName">QXmlName::fromClarkName(QString,QXmlNamePool)</a></p>
     */
    public static io.qt.xmlpatterns.@NonNull QXmlName fromClarkName(java.lang.@NonNull String clarkName, io.qt.xmlpatterns.@NonNull QXmlNamePool namePool){
        return fromClarkName_native_cref_QString_cref_QXmlNamePool(clarkName, QtJambi_LibraryUtilities.internal.checkedNativeId(namePool));
    }
    
    private native static io.qt.xmlpatterns.QXmlName fromClarkName_native_cref_QString_cref_QXmlNamePool(java.lang.String clarkName, long namePool);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlname.html#isNCName">QXmlName::isNCName(QString)</a></p>
     */
    public native static boolean isNCName(java.lang.@NonNull String candidate);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QXmlName(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xmlpatterns.QXmlName) {
            return operator_equal((io.qt.xmlpatterns.QXmlName) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QXmlName clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QXmlName clone_native(long __this_nativeId);
}
