package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Abstract base class for modeling non-XML data to look like XML for QXmlQuery</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html">QAbstractXmlNodeModel</a></p>
 */
public abstract class QAbstractXmlNodeModel extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractXmlNodeModel {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        protected java.util.@NonNull List<io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex> attributes(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex element){
            return attributes_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(element));
        }
        @QtUninvokable
        private native java.util.List<io.qt.xmlpatterns.QXmlNodeModelIndex> attributes_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long element);
        
        
        @Override
        @QtUninvokable
        public io.qt.core.@NonNull QUrl baseUri(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni){
            return baseUri_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ni));
        }
        @QtUninvokable
        private native io.qt.core.QUrl baseUri_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni);
        
        
        @Override
        @QtUninvokable
        public io.qt.xmlpatterns.QXmlNodeModelIndex.@NonNull DocumentOrder compareOrder(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni1, io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni2){
            return io.qt.xmlpatterns.QXmlNodeModelIndex.DocumentOrder.resolve(compareOrder_native_cref_QXmlNodeModelIndex_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ni1), QtJambi_LibraryUtilities.internal.checkedNativeId(ni2)));
        }
        @QtUninvokable
        private native int compareOrder_native_cref_QXmlNodeModelIndex_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni1, long ni2);
        
        
        @Override
        @QtUninvokable
        public io.qt.core.@NonNull QUrl documentUri(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni){
            return documentUri_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ni));
        }
        @QtUninvokable
        private native io.qt.core.QUrl documentUri_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni);
        
        
        @Override
        @QtUninvokable
        public io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex elementById(io.qt.xmlpatterns.@NonNull QXmlName NCName){
            return elementById_native_cref_QXmlName_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(NCName));
        }
        @QtUninvokable
        private native io.qt.xmlpatterns.QXmlNodeModelIndex elementById_native_cref_QXmlName_constfct(long __this__nativeId, long NCName);
        
        
        @Override
        @QtUninvokable
        public io.qt.xmlpatterns.QXmlNodeModelIndex.@NonNull NodeKind kind(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni){
            return io.qt.xmlpatterns.QXmlNodeModelIndex.NodeKind.resolve(kind_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ni)));
        }
        @QtUninvokable
        private native int kind_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni);
        
        
        @Override
        @QtUninvokable
        public io.qt.xmlpatterns.@NonNull QXmlName name(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni){
            return name_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(ni));
        }
        @QtUninvokable
        private native io.qt.xmlpatterns.QXmlName name_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni);
        
        
        @Override
        @QtUninvokable
        public java.util.@NonNull List<io.qt.xmlpatterns.@NonNull QXmlName> namespaceBindings(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex n){
            return namespaceBindings_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(n));
        }
        @QtUninvokable
        private native java.util.List<io.qt.xmlpatterns.QXmlName> namespaceBindings_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long n);
        
        
        @Override
        @QtUninvokable
        protected io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex nextFromSimpleAxis(io.qt.xmlpatterns.QAbstractXmlNodeModel.@NonNull SimpleAxis axis, io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex origin){
            return nextFromSimpleAxis_native_QAbstractXmlNodeModel_SimpleAxis_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), axis.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(origin));
        }
        @QtUninvokable
        private native io.qt.xmlpatterns.QXmlNodeModelIndex nextFromSimpleAxis_native_QAbstractXmlNodeModel_SimpleAxis_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, int axis, long origin);
        
        
        @Override
        @QtUninvokable
        public java.util.@NonNull List<io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex> nodesByIdref(io.qt.xmlpatterns.@NonNull QXmlName NCName){
            return nodesByIdref_native_cref_QXmlName_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(NCName));
        }
        @QtUninvokable
        private native java.util.List<io.qt.xmlpatterns.QXmlNodeModelIndex> nodesByIdref_native_cref_QXmlName_constfct(long __this__nativeId, long NCName);
        
        
        @Override
        @QtUninvokable
        public io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex root(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex n){
            return root_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(n));
        }
        @QtUninvokable
        private native io.qt.xmlpatterns.QXmlNodeModelIndex root_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long n);
        
        
        @Override
        @QtUninvokable
        public java.lang.@NonNull String stringValue(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex n){
            return stringValue_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(n));
        }
        @QtUninvokable
        private native java.lang.String stringValue_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long n);
        
        
        @Override
        @QtUninvokable
        public java.lang.Object typedValue(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex n){
            return typedValue_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(n));
        }
        @QtUninvokable
        private native java.lang.Object typedValue_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long n);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum QAbstractXmlNodeModel::NodeCopySetting</p>
     * 
     * @see NodeCopySettings
     */
    public enum NodeCopySetting implements QtFlagEnumerator {
        /**
         * <p>Representing QAbstractXmlNodeModel::InheritNamespaces</p>
         */
        InheritNamespaces(1),
        /**
         * <p>Representing QAbstractXmlNodeModel::PreserveNamespaces</p>
         */
        PreserveNamespaces(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NodeCopySetting(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull NodeCopySettings asFlags() {
            return new NodeCopySettings(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull NodeCopySettings combined(@NonNull NodeCopySetting e) {
            return new NodeCopySettings(this, e);
        }

        /**
         * Creates a new {@link NodeCopySettings} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull NodeCopySettings flags(@Nullable NodeCopySetting @NonNull... values) {
            return new NodeCopySettings(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NodeCopySetting resolve(int value) {
            switch (value) {
            case 1: return InheritNamespaces;
            case 2: return PreserveNamespaces;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link NodeCopySetting}
     */
    public static final class NodeCopySettings extends QFlags<NodeCopySetting> implements Comparable<NodeCopySettings> {
        private static final long serialVersionUID = 0x43088d2f973f3a1dL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new NodeCopySettings where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public NodeCopySettings(@Nullable NodeCopySetting @NonNull... args){
            super(args);
        }

        /**
         * Creates a new NodeCopySettings with given <code>value</code>.
         * @param value
         */
        public NodeCopySettings(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new NodeCopySettings
         */
        @Override
        public final @NonNull NodeCopySettings combined(@StrictNonNull NodeCopySetting e){
            return new NodeCopySettings(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull NodeCopySettings setFlag(@Nullable NodeCopySetting e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull NodeCopySettings setFlag(@Nullable NodeCopySetting e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this NodeCopySettings.
         * @return array of enum entries
         */
        @Override
        public final @NonNull NodeCopySetting @NonNull[] flags(){
            return super.flags(NodeCopySetting.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull NodeCopySettings clone(){
            return new NodeCopySettings(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull NodeCopySettings other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#SimpleAxis-enum">QAbstractXmlNodeModel::SimpleAxis</a></p>
     */
    public enum SimpleAxis implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#SimpleAxis-enum">QAbstractXmlNodeModel::Parent</a></p>
         */
        Parent(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#SimpleAxis-enum">QAbstractXmlNodeModel::FirstChild</a></p>
         */
        FirstChild(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#SimpleAxis-enum">QAbstractXmlNodeModel::PreviousSibling</a></p>
         */
        PreviousSibling(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#SimpleAxis-enum">QAbstractXmlNodeModel::NextSibling</a></p>
         */
        NextSibling(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SimpleAxis(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SimpleAxis resolve(int value) {
            switch (value) {
            case 0: return Parent;
            case 1: return FirstChild;
            case 2: return PreviousSibling;
            case 3: return NextSibling;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#QAbstractXmlNodeModel">QAbstractXmlNodeModel::QAbstractXmlNodeModel()</a></p>
     */
    public QAbstractXmlNodeModel(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAbstractXmlNodeModel instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#createIndex">QAbstractXmlNodeModel::createIndex(qint64)const</a></p>
     */
    @QtUninvokable
    protected final io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex createIndex(long data){
        return createIndex_native_qint64_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNodeModelIndex createIndex_native_qint64_constfct(long __this__nativeId, long data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#createIndex-2">QAbstractXmlNodeModel::createIndex(qint64,qint64)const</a></p>
     */
    @QtUninvokable
    protected final io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex createIndex(long data, long additionalData){
        return createIndex_native_qint64_qint64_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), data, additionalData);
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNodeModelIndex createIndex_native_qint64_qint64_constfct(long __this__nativeId, long data, long additionalData);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#sourceLocation">QAbstractXmlNodeModel::sourceLocation(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@NonNull QSourceLocation sourceLocation(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex index){
        return sourceLocation_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QSourceLocation sourceLocation_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#attributes">QAbstractXmlNodeModel::attributes(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    protected abstract java.util.@NonNull List<io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex> attributes(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex element);
    
    @QtUninvokable
    private native java.util.List<io.qt.xmlpatterns.QXmlNodeModelIndex> attributes_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long element);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#baseUri">QAbstractXmlNodeModel::baseUri(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.core.@NonNull QUrl baseUri(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni);
    
    @QtUninvokable
    private native io.qt.core.QUrl baseUri_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#compareOrder">QAbstractXmlNodeModel::compareOrder(QXmlNodeModelIndex,QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.xmlpatterns.QXmlNodeModelIndex.@NonNull DocumentOrder compareOrder(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni1, io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni2);
    
    @QtUninvokable
    private native int compareOrder_native_cref_QXmlNodeModelIndex_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni1, long ni2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#documentUri">QAbstractXmlNodeModel::documentUri(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.core.@NonNull QUrl documentUri(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni);
    
    @QtUninvokable
    private native io.qt.core.QUrl documentUri_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#elementById">QAbstractXmlNodeModel::elementById(QXmlName)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex elementById(io.qt.xmlpatterns.@NonNull QXmlName NCName);
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNodeModelIndex elementById_native_cref_QXmlName_constfct(long __this__nativeId, long NCName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#kind">QAbstractXmlNodeModel::kind(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.xmlpatterns.QXmlNodeModelIndex.@NonNull NodeKind kind(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni);
    
    @QtUninvokable
    private native int kind_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#name">QAbstractXmlNodeModel::name(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.xmlpatterns.@NonNull QXmlName name(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex ni);
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlName name_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long ni);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#namespaceBindings">QAbstractXmlNodeModel::namespaceBindings(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public abstract java.util.@NonNull List<io.qt.xmlpatterns.@NonNull QXmlName> namespaceBindings(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex n);
    
    @QtUninvokable
    private native java.util.List<io.qt.xmlpatterns.QXmlName> namespaceBindings_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long n);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#nextFromSimpleAxis">QAbstractXmlNodeModel::nextFromSimpleAxis(QAbstractXmlNodeModel::SimpleAxis,QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    protected abstract io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex nextFromSimpleAxis(io.qt.xmlpatterns.QAbstractXmlNodeModel.@NonNull SimpleAxis axis, io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex origin);
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNodeModelIndex nextFromSimpleAxis_native_QAbstractXmlNodeModel_SimpleAxis_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, int axis, long origin);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#nodesByIdref">QAbstractXmlNodeModel::nodesByIdref(QXmlName)const</a></p>
     */
    @QtUninvokable
    public abstract java.util.@NonNull List<io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex> nodesByIdref(io.qt.xmlpatterns.@NonNull QXmlName NCName);
    
    @QtUninvokable
    private native java.util.List<io.qt.xmlpatterns.QXmlNodeModelIndex> nodesByIdref_native_cref_QXmlName_constfct(long __this__nativeId, long NCName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#root">QAbstractXmlNodeModel::root(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex root(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex n);
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QXmlNodeModelIndex root_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long n);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#stringValue">QAbstractXmlNodeModel::stringValue(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public abstract java.lang.@NonNull String stringValue(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex n);
    
    @QtUninvokable
    private native java.lang.String stringValue_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long n);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlnodemodel.html#typedValue">QAbstractXmlNodeModel::typedValue(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    public abstract java.lang.Object typedValue(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex n);
    
    @QtUninvokable
    private native java.lang.Object typedValue_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long n);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractXmlNodeModel(QPrivateConstructor p) { super(p); } 
    
}
