package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Callback interface for resolving Uniform Resource Identifiers. A Uniform Resource Identifier (URI) is a string that uniquely identifies a resource. URIs are versatile global identifiers. It is often useful to transform a URI that identifies something logical into a URI that locates something physical (a URL), or to simply map a URI to a different URI. QAbstractUriResolver::resolve() provides this functionality</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qabstracturiresolver.html">QAbstractUriResolver</a></p>
 */
public abstract class QAbstractUriResolver extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractUriResolver.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractUriResolver {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public io.qt.core.@NonNull QUrl resolve(io.qt.core.@NonNull QUrl relative, io.qt.core.@NonNull QUrl baseURI){
            return resolve_native_cref_QUrl_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(relative), QtJambi_LibraryUtilities.internal.checkedNativeId(baseURI));
        }
        @QtUninvokable
        private native io.qt.core.QUrl resolve_native_cref_QUrl_cref_QUrl_constfct(long __this__nativeId, long relative, long baseURI);
        
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractUriResolver(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractUriResolver() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstracturiresolver.html#QAbstractUriResolver">QAbstractUriResolver::QAbstractUriResolver(QObject*)</a></p>
     */
    public QAbstractUriResolver(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractUriResolver instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstracturiresolver.html#resolve">QAbstractUriResolver::resolve(QUrl,QUrl)const</a></p>
     */
    @QtUninvokable
    public abstract io.qt.core.@NonNull QUrl resolve(io.qt.core.@NonNull QUrl relative, io.qt.core.@NonNull QUrl baseURI);
    
    @QtUninvokable
    private native io.qt.core.QUrl resolve_native_cref_QUrl_cref_QUrl_constfct(long __this__nativeId, long relative, long baseURI);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractUriResolver(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAbstractUriResolver(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractUriResolver instance, QDeclarativeConstructor constructor);
    
}
