package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Identifies a node in an XML node model subclassed from QAbstractXmlNodeModel</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html">QXmlNodeModelIndex</a></p>
 */
public class QXmlNodeModelIndex extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#DocumentOrder-enum">QXmlNodeModelIndex::DocumentOrder</a></p>
     */
    public enum DocumentOrder implements QtEnumerator {
        Precedes(-1),
        Is(0),
        Follows(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DocumentOrder(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DocumentOrder resolve(int value) {
            switch (value) {
            case -1: return Precedes;
            case 0: return Is;
            case 1: return Follows;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#NodeKind-enum">QXmlNodeModelIndex::NodeKind</a></p>
     */
    public enum NodeKind implements QtEnumerator {
        Attribute(1),
        Comment(2),
        Document(4),
        Element(8),
        Namespace(16),
        ProcessingInstruction(32),
        Text(64);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NodeKind(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static NodeKind resolve(int value) {
            switch (value) {
            case 1: return Attribute;
            case 2: return Comment;
            case 4: return Document;
            case 8: return Element;
            case 16: return Namespace;
            case 32: return ProcessingInstruction;
            case 64: return Text;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#QXmlNodeModelIndex">QXmlNodeModelIndex::QXmlNodeModelIndex()</a></p>
     */
    public QXmlNodeModelIndex(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlNodeModelIndex instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#QXmlNodeModelIndex-1">QXmlNodeModelIndex::QXmlNodeModelIndex(QXmlNodeModelIndex)</a></p>
     */
    public QXmlNodeModelIndex(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QXmlNodeModelIndex instance, io.qt.xmlpatterns.QXmlNodeModelIndex other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#additionalData">QXmlNodeModelIndex::additionalData()const</a></p>
     */
    @QtUninvokable
    public final long additionalData(){
        return additionalData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long additionalData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#data">QXmlNodeModelIndex::data()const</a></p>
     */
    @QtUninvokable
    public final long data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#isNull">QXmlNodeModelIndex::isNull()const</a></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#model">QXmlNodeModelIndex::model()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xmlpatterns.@Nullable QAbstractXmlNodeModel model(){
        return model_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xmlpatterns.QAbstractXmlNodeModel model_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void assign(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex arg__1){
        assign_native_cref_QXmlNodeModelIndex(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QXmlNodeModelIndex(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlnodemodelindex.html#operator-eq-eq">QXmlNodeModelIndex::operator==(QXmlNodeModelIndex)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.xmlpatterns.@NonNull QXmlNodeModelIndex other){
        return operator_equal_native_cref_QXmlNodeModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QXmlNodeModelIndex_constfct(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QXmlNodeModelIndex(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xmlpatterns.QXmlNodeModelIndex) {
            return operator_equal((io.qt.xmlpatterns.QXmlNodeModelIndex) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QXmlNodeModelIndex clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QXmlNodeModelIndex clone_native(long __this_nativeId);
}
