package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Implementation of QXmlSerializer for transforming XQuery output into formatted XML</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qxmlformatter.html">QXmlFormatter</a></p>
 */
public class QXmlFormatter extends io.qt.xmlpatterns.QXmlSerializer
{
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlformatter.html#QXmlFormatter">QXmlFormatter::QXmlFormatter(QXmlQuery,QIODevice*)</a></p>
     */
    public QXmlFormatter(io.qt.xmlpatterns.@StrictNonNull QXmlQuery query, io.qt.core.@Nullable QIODevice outputDevice){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(query, "Argument 'query': null not expected.");
        initialize_native(this, query, outputDevice);
    }
    
    private native static void initialize_native(QXmlFormatter instance, io.qt.xmlpatterns.QXmlQuery query, io.qt.core.QIODevice outputDevice);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlformatter.html#indentationDepth">QXmlFormatter::indentationDepth()const</a></p>
     */
    @QtUninvokable
    public final int indentationDepth(){
        return indentationDepth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int indentationDepth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlformatter.html#setIndentationDepth">QXmlFormatter::setIndentationDepth(int)</a></p>
     */
    @QtUninvokable
    public final void setIndentationDepth(int depth){
        setIndentationDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void setIndentationDepth_native_int(long __this__nativeId, int depth);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#atomicValue">QAbstractXmlReceiver::atomicValue(QVariant)</a></p>
     */
    @QtUninvokable
    public void atomicValue(java.lang.Object value){
        atomicValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void atomicValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#attribute">QAbstractXmlReceiver::attribute(QXmlName,QStringRef)</a></p>
     */
    @QtUninvokable
    public void attribute(io.qt.xmlpatterns.@NonNull QXmlName name, java.lang.@NonNull String value){
        attribute_native_cref_QXmlName_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), value);
    }
    
    @QtUninvokable
    private native void attribute_native_cref_QXmlName_cref_QStringRef(long __this__nativeId, long name, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#characters">QAbstractXmlReceiver::characters(QStringRef)</a></p>
     */
    @QtUninvokable
    public void characters(java.lang.@NonNull String value){
        characters_native_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void characters_native_cref_QStringRef(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#comment">QAbstractXmlReceiver::comment(QString)</a></p>
     */
    @QtUninvokable
    public void comment(java.lang.@NonNull String value){
        comment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void comment_native_cref_QString(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endDocument">QAbstractXmlReceiver::endDocument()</a></p>
     */
    @QtUninvokable
    public void endDocument(){
        endDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endDocument_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endElement">QAbstractXmlReceiver::endElement()</a></p>
     */
    @QtUninvokable
    public void endElement(){
        endElement_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endElement_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endOfSequence">QAbstractXmlReceiver::endOfSequence()</a></p>
     */
    @QtUninvokable
    public void endOfSequence(){
        endOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void endOfSequence_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#processingInstruction">QAbstractXmlReceiver::processingInstruction(QXmlName,QString)</a></p>
     */
    @QtUninvokable
    public void processingInstruction(io.qt.xmlpatterns.@NonNull QXmlName name, java.lang.@NonNull String value){
        processingInstruction_native_cref_QXmlName_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), value);
    }
    
    @QtUninvokable
    private native void processingInstruction_native_cref_QXmlName_cref_QString(long __this__nativeId, long name, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startDocument">QAbstractXmlReceiver::startDocument()</a></p>
     */
    @QtUninvokable
    public void startDocument(){
        startDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void startDocument_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startElement">QAbstractXmlReceiver::startElement(QXmlName)</a></p>
     */
    @QtUninvokable
    public void startElement(io.qt.xmlpatterns.@NonNull QXmlName name){
        startElement_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @QtUninvokable
    private native void startElement_native_cref_QXmlName(long __this__nativeId, long name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startOfSequence">QAbstractXmlReceiver::startOfSequence()</a></p>
     */
    @QtUninvokable
    public void startOfSequence(){
        startOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void startOfSequence_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QXmlFormatter(QPrivateConstructor p) { super(p); } 
    
}
