package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Callback interface for transforming the output of a QXmlQuery</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html">QAbstractXmlReceiver</a></p>
 */
public abstract class QAbstractXmlReceiver extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractXmlReceiver {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public void atomicValue(java.lang.Object value){
            atomicValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
        }
        @QtUninvokable
        private native void atomicValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
        
        
        @Override
        @QtUninvokable
        public void attribute(io.qt.xmlpatterns.@NonNull QXmlName name, java.lang.@NonNull String value){
            attribute_native_cref_QXmlName_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), value);
        }
        @QtUninvokable
        private native void attribute_native_cref_QXmlName_cref_QStringRef(long __this__nativeId, long name, java.lang.String value);
        
        
        @Override
        @QtUninvokable
        public void characters(java.lang.@NonNull String value){
            characters_native_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), value);
        }
        @QtUninvokable
        private native void characters_native_cref_QStringRef(long __this__nativeId, java.lang.String value);
        
        
        @Override
        @QtUninvokable
        public void comment(java.lang.@NonNull String value){
            comment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), value);
        }
        @QtUninvokable
        private native void comment_native_cref_QString(long __this__nativeId, java.lang.String value);
        
        
        @Override
        @QtUninvokable
        public void endDocument(){
            endDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void endDocument_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void endElement(){
            endElement_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void endElement_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void endOfSequence(){
            endOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void endOfSequence_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void namespaceBinding(io.qt.xmlpatterns.@NonNull QXmlName name){
            namespaceBinding_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
        }
        @QtUninvokable
        private native void namespaceBinding_native_cref_QXmlName(long __this__nativeId, long name);
        
        
        @Override
        @QtUninvokable
        public void processingInstruction(io.qt.xmlpatterns.@NonNull QXmlName target, java.lang.@NonNull String value){
            processingInstruction_native_cref_QXmlName_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target), value);
        }
        @QtUninvokable
        private native void processingInstruction_native_cref_QXmlName_cref_QString(long __this__nativeId, long target, java.lang.String value);
        
        
        @Override
        @QtUninvokable
        public void startDocument(){
            startDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void startDocument_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public void startElement(io.qt.xmlpatterns.@NonNull QXmlName name){
            startElement_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
        }
        @QtUninvokable
        private native void startElement_native_cref_QXmlName(long __this__nativeId, long name);
        
        
        @Override
        @QtUninvokable
        public void startOfSequence(){
            startOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native void startOfSequence_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#QAbstractXmlReceiver">QAbstractXmlReceiver::QAbstractXmlReceiver()</a></p>
     */
    public QAbstractXmlReceiver(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAbstractXmlReceiver instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#atomicValue">QAbstractXmlReceiver::atomicValue(QVariant)</a></p>
     */
    @QtUninvokable
    public abstract void atomicValue(java.lang.Object value);
    
    @QtUninvokable
    private native void atomicValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#attribute">QAbstractXmlReceiver::attribute(QXmlName,QStringRef)</a></p>
     */
    @QtUninvokable
    public abstract void attribute(io.qt.xmlpatterns.@NonNull QXmlName name, java.lang.@NonNull String value);
    
    @QtUninvokable
    private native void attribute_native_cref_QXmlName_cref_QStringRef(long __this__nativeId, long name, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#characters">QAbstractXmlReceiver::characters(QStringRef)</a></p>
     */
    @QtUninvokable
    public abstract void characters(java.lang.@NonNull String value);
    
    @QtUninvokable
    private native void characters_native_cref_QStringRef(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#comment">QAbstractXmlReceiver::comment(QString)</a></p>
     */
    @QtUninvokable
    public abstract void comment(java.lang.@NonNull String value);
    
    @QtUninvokable
    private native void comment_native_cref_QString(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endDocument">QAbstractXmlReceiver::endDocument()</a></p>
     */
    @QtUninvokable
    public abstract void endDocument();
    
    @QtUninvokable
    private native void endDocument_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endElement">QAbstractXmlReceiver::endElement()</a></p>
     */
    @QtUninvokable
    public abstract void endElement();
    
    @QtUninvokable
    private native void endElement_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endOfSequence">QAbstractXmlReceiver::endOfSequence()</a></p>
     */
    @QtUninvokable
    public abstract void endOfSequence();
    
    @QtUninvokable
    private native void endOfSequence_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#namespaceBinding">QAbstractXmlReceiver::namespaceBinding(QXmlName)</a></p>
     */
    @QtUninvokable
    public abstract void namespaceBinding(io.qt.xmlpatterns.@NonNull QXmlName name);
    
    @QtUninvokable
    private native void namespaceBinding_native_cref_QXmlName(long __this__nativeId, long name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#processingInstruction">QAbstractXmlReceiver::processingInstruction(QXmlName,QString)</a></p>
     */
    @QtUninvokable
    public abstract void processingInstruction(io.qt.xmlpatterns.@NonNull QXmlName target, java.lang.@NonNull String value);
    
    @QtUninvokable
    private native void processingInstruction_native_cref_QXmlName_cref_QString(long __this__nativeId, long target, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startDocument">QAbstractXmlReceiver::startDocument()</a></p>
     */
    @QtUninvokable
    public abstract void startDocument();
    
    @QtUninvokable
    private native void startDocument_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startElement">QAbstractXmlReceiver::startElement(QXmlName)</a></p>
     */
    @QtUninvokable
    public abstract void startElement(io.qt.xmlpatterns.@NonNull QXmlName name);
    
    @QtUninvokable
    private native void startElement_native_cref_QXmlName(long __this__nativeId, long name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startOfSequence">QAbstractXmlReceiver::startOfSequence()</a></p>
     */
    @QtUninvokable
    public abstract void startOfSequence();
    
    @QtUninvokable
    private native void startOfSequence_native(long __this__nativeId);
    
    @QtUninvokable
    public void whitespaceOnly(java.lang.@NonNull String value){
        whitespaceOnly_native_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void whitespaceOnly_native_cref_QStringRef(long __this__nativeId, java.lang.String value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractXmlReceiver(QPrivateConstructor p) { super(p); } 
    
}
