package io.qt.xmlpatterns;

import io.qt.*;


/**
 * <p>Callback interface for handling messages</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qabstractmessagehandler.html">QAbstractMessageHandler</a></p>
 */
public abstract class QAbstractMessageHandler extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractMessageHandler.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractMessageHandler {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        protected void handleMessage(io.qt.core.@NonNull QtMsgType type, java.lang.@NonNull String description, io.qt.core.@NonNull QUrl identifier, io.qt.xmlpatterns.@NonNull QSourceLocation sourceLocation){
            handleMessage_native_QtMsgType_cref_QString_cref_QUrl_cref_QSourceLocation(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), description, QtJambi_LibraryUtilities.internal.checkedNativeId(identifier), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceLocation));
        }
        @QtUninvokable
        private native void handleMessage_native_QtMsgType_cref_QString_cref_QUrl_cref_QSourceLocation(long __this__nativeId, int type, java.lang.String description, long identifier, long sourceLocation);
        
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractMessageHandler() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractmessagehandler.html#QAbstractMessageHandler">QAbstractMessageHandler::QAbstractMessageHandler(QObject*)</a></p>
     */
    public QAbstractMessageHandler(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractMessageHandler instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded function for {@link #message(io.qt.core.QtMsgType, java.lang.String, io.qt.core.QUrl, io.qt.xmlpatterns.QSourceLocation)}
     *  with <code>sourceLocation = new io.qt.xmlpatterns.QSourceLocation()</code>.</p>
     */
    @QtUninvokable
    public final void message(io.qt.core.@NonNull QtMsgType type, java.lang.@NonNull String description, io.qt.core.@NonNull QUrl identifier) {
        message(type, description, identifier, new io.qt.xmlpatterns.QSourceLocation());
    }
    
    /**
     * <p>Overloaded function for {@link #message(io.qt.core.QtMsgType, java.lang.String, io.qt.core.QUrl, io.qt.xmlpatterns.QSourceLocation)}</p>
     * <p>with: </p><ul>
     * <li><code>identifier = new io.qt.core.QUrl()</code></li>
     * <li><code>sourceLocation = new io.qt.xmlpatterns.QSourceLocation()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void message(io.qt.core.@NonNull QtMsgType type, java.lang.@NonNull String description) {
        message(type, description, new io.qt.core.QUrl(), new io.qt.xmlpatterns.QSourceLocation());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractmessagehandler.html#message">QAbstractMessageHandler::message(QtMsgType,QString,QUrl,QSourceLocation)</a></p>
     */
    @QtUninvokable
    public final void message(io.qt.core.@NonNull QtMsgType type, java.lang.@NonNull String description, io.qt.core.@NonNull QUrl identifier, io.qt.xmlpatterns.@NonNull QSourceLocation sourceLocation){
        message_native_QtMsgType_cref_QString_cref_QUrl_cref_QSourceLocation(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), description, QtJambi_LibraryUtilities.internal.checkedNativeId(identifier), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceLocation));
    }
    
    @QtUninvokable
    private native void message_native_QtMsgType_cref_QString_cref_QUrl_cref_QSourceLocation(long __this__nativeId, int type, java.lang.String description, long identifier, long sourceLocation);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractmessagehandler.html#handleMessage">QAbstractMessageHandler::handleMessage(QtMsgType,QString,QUrl,QSourceLocation)</a></p>
     */
    @QtUninvokable
    protected abstract void handleMessage(io.qt.core.@NonNull QtMsgType type, java.lang.@NonNull String description, io.qt.core.@NonNull QUrl identifier, io.qt.xmlpatterns.@NonNull QSourceLocation sourceLocation);
    
    @QtUninvokable
    private native void handleMessage_native_QtMsgType_cref_QString_cref_QUrl_cref_QSourceLocation(long __this__nativeId, int type, java.lang.String description, long identifier, long sourceLocation);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractMessageHandler(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAbstractMessageHandler(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractMessageHandler instance, QDeclarativeConstructor constructor);
    
}
