package io.qt.xmlpatterns;


/**
 * <p>Loading and validation of a W3C XML Schema</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qxmlschema.html">QXmlSchema</a></p>
 */
public class QXmlSchema extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#QXmlSchema">QXmlSchema::QXmlSchema()</a></p>
     */
    public QXmlSchema(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QXmlSchema instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#QXmlSchema-1">QXmlSchema::QXmlSchema(QXmlSchema)</a></p>
     */
    public QXmlSchema(io.qt.xmlpatterns.QXmlSchema other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QXmlSchema instance, io.qt.xmlpatterns.QXmlSchema other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#documentUri">QXmlSchema::documentUri()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl documentUri(){
        return documentUri_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl documentUri_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#isValid">QXmlSchema::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #load(io.qt.core.QIODevice, io.qt.core.QUrl)}
     *  with <code>documentUri = new io.qt.core.QUrl()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean load(io.qt.core.QIODevice source) {
        return load(source, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#load-1">QXmlSchema::load(QIODevice*,QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean load(io.qt.core.QIODevice source, io.qt.core.QUrl documentUri){
        return load_native_QIODevice_ptr_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source), QtJambi_LibraryUtilities.internal.checkedNativeId(documentUri));
    }
    
    @io.qt.QtUninvokable
    private native boolean load_native_QIODevice_ptr_cref_QUrl(long __this__nativeId, long source, long documentUri);
    
    /**
     * <p>Overloaded function for {@link #load(io.qt.core.QByteArray, io.qt.core.QUrl)}
     *  with <code>documentUri = new io.qt.core.QUrl()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean load(io.qt.core.QByteArray data) {
        return load(data, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#load-2">QXmlSchema::load(QByteArray,QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean load(io.qt.core.QByteArray data, io.qt.core.QUrl documentUri){
        return load_native_cref_QByteArray_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), QtJambi_LibraryUtilities.internal.checkedNativeId(documentUri));
    }
    
    @io.qt.QtUninvokable
    private native boolean load_native_cref_QByteArray_cref_QUrl(long __this__nativeId, long data, long documentUri);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#load">QXmlSchema::load(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean load(io.qt.core.QUrl source){
        return load_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @io.qt.QtUninvokable
    private native boolean load_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#messageHandler">QXmlSchema::messageHandler()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xmlpatterns.QAbstractMessageHandler messageHandler(){
        return messageHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xmlpatterns.QAbstractMessageHandler messageHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#namePool">QXmlSchema::namePool()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xmlpatterns.QXmlNamePool namePool(){
        return namePool_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xmlpatterns.QXmlNamePool namePool_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#networkAccessManager">QXmlSchema::networkAccessManager()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.network.QNetworkAccessManager networkAccessManager(){
        return networkAccessManager_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.network.QNetworkAccessManager networkAccessManager_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#setMessageHandler">QXmlSchema::setMessageHandler(QAbstractMessageHandler*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMessageHandler(io.qt.xmlpatterns.QAbstractMessageHandler handler){
        setMessageHandler_native_QAbstractMessageHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(handler));
    }
    
    @io.qt.QtUninvokable
    private native void setMessageHandler_native_QAbstractMessageHandler_ptr(long __this__nativeId, long handler);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#setNetworkAccessManager">QXmlSchema::setNetworkAccessManager(QNetworkAccessManager*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setNetworkAccessManager(io.qt.network.QNetworkAccessManager networkmanager){
        setNetworkAccessManager_native_QNetworkAccessManager_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(networkmanager));
    }
    
    @io.qt.QtUninvokable
    private native void setNetworkAccessManager_native_QNetworkAccessManager_ptr(long __this__nativeId, long networkmanager);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#setUriResolver">QXmlSchema::setUriResolver(const QAbstractUriResolver*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUriResolver(io.qt.xmlpatterns.QAbstractUriResolver resolver){
        setUriResolver_native_const_QAbstractUriResolver_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(resolver));
    }
    
    @io.qt.QtUninvokable
    private native void setUriResolver_native_const_QAbstractUriResolver_ptr(long __this__nativeId, long resolver);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlschema.html#uriResolver">QXmlSchema::uriResolver()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xmlpatterns.QAbstractUriResolver uriResolver(){
        return uriResolver_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xmlpatterns.QAbstractUriResolver uriResolver_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QXmlSchema(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QXmlSchema clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QXmlSchema clone_native(long __this_nativeId);
}
