package io.qt.xmlpatterns;


/**
 * <p>Implementation of QAbstractXmlReceiver for transforming XQuery output into unformatted XML</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qxmlserializer.html">QXmlSerializer</a></p>
 */
public class QXmlSerializer extends io.qt.xmlpatterns.QAbstractXmlReceiver
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcCodec = null;
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlserializer.html#QXmlSerializer">QXmlSerializer::QXmlSerializer(QXmlQuery,QIODevice*)</a></p>
     */
    public QXmlSerializer(io.qt.xmlpatterns.QXmlQuery query, io.qt.core.QIODevice outputDevice){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(query, "Argument 'query': null not expected.");
        initialize_native(this, query, outputDevice);
    }
    
    private native static void initialize_native(QXmlSerializer instance, io.qt.xmlpatterns.QXmlQuery query, io.qt.core.QIODevice outputDevice);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlserializer.html#codec">QXmlSerializer::codec()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QTextCodec codec(){
        return codec_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QTextCodec codec_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlserializer.html#outputDevice">QXmlSerializer::outputDevice()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QIODevice outputDevice(){
        return outputDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QIODevice outputDevice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qxmlserializer.html#setCodec">QXmlSerializer::setCodec(const QTextCodec*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCodec(io.qt.core.QTextCodec codec){
        setCodec_native_const_QTextCodec_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(codec));
        __rcCodec = codec;
    }
    
    @io.qt.QtUninvokable
    private native void setCodec_native_const_QTextCodec_ptr(long __this__nativeId, long codec);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#atomicValue">QAbstractXmlReceiver::atomicValue(QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public void atomicValue(java.lang.Object value){
        atomicValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void atomicValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#attribute">QAbstractXmlReceiver::attribute(QXmlName,QStringRef)</a></p>
     */
    @io.qt.QtUninvokable
    public void attribute(io.qt.xmlpatterns.QXmlName name, java.lang.String value){
        attribute_native_cref_QXmlName_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), value);
    }
    
    @io.qt.QtUninvokable
    private native void attribute_native_cref_QXmlName_cref_QStringRef(long __this__nativeId, long name, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#characters">QAbstractXmlReceiver::characters(QStringRef)</a></p>
     */
    @io.qt.QtUninvokable
    public void characters(java.lang.String value){
        characters_native_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void characters_native_cref_QStringRef(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#comment">QAbstractXmlReceiver::comment(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public void comment(java.lang.String value){
        comment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void comment_native_cref_QString(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endDocument">QAbstractXmlReceiver::endDocument()</a></p>
     */
    @io.qt.QtUninvokable
    public void endDocument(){
        endDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void endDocument_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endElement">QAbstractXmlReceiver::endElement()</a></p>
     */
    @io.qt.QtUninvokable
    public void endElement(){
        endElement_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void endElement_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endOfSequence">QAbstractXmlReceiver::endOfSequence()</a></p>
     */
    @io.qt.QtUninvokable
    public void endOfSequence(){
        endOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void endOfSequence_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#namespaceBinding">QAbstractXmlReceiver::namespaceBinding(QXmlName)</a></p>
     */
    @io.qt.QtUninvokable
    public void namespaceBinding(io.qt.xmlpatterns.QXmlName nb){
        namespaceBinding_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(nb));
    }
    
    @io.qt.QtUninvokable
    private native void namespaceBinding_native_cref_QXmlName(long __this__nativeId, long nb);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#processingInstruction">QAbstractXmlReceiver::processingInstruction(QXmlName,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public void processingInstruction(io.qt.xmlpatterns.QXmlName name, java.lang.String value){
        processingInstruction_native_cref_QXmlName_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), value);
    }
    
    @io.qt.QtUninvokable
    private native void processingInstruction_native_cref_QXmlName_cref_QString(long __this__nativeId, long name, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startDocument">QAbstractXmlReceiver::startDocument()</a></p>
     */
    @io.qt.QtUninvokable
    public void startDocument(){
        startDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void startDocument_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startElement">QAbstractXmlReceiver::startElement(QXmlName)</a></p>
     */
    @io.qt.QtUninvokable
    public void startElement(io.qt.xmlpatterns.QXmlName name){
        startElement_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @io.qt.QtUninvokable
    private native void startElement_native_cref_QXmlName(long __this__nativeId, long name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startOfSequence">QAbstractXmlReceiver::startOfSequence()</a></p>
     */
    @io.qt.QtUninvokable
    public void startOfSequence(){
        startOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void startOfSequence_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QXmlSerializer(QPrivateConstructor p) { super(p); } 
    
}
